package gov.va.med.pharmacy.hazardous;

import gov.va.med.pharmacy.hazardous.parser.HazardousParserException;
import gov.va.med.pharmacy.hazardous.parser.HazardousWasteParser;
import gov.va.med.pharmacy.hazardous.parser.IHazardousParser;
import gov.va.med.pharmacy.hazardous.util.Arguments;
import gov.va.med.pharmacy.hazardous.util.Log;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public class HazardousUploadMain {

	public final static String BAD_ARGUMENTS = "\n"
			+ "\nWrong number of arguments. This program needs 4 or 6 arguments."
			+ "\nExample: java -jar hazardous-upload.jar -a=update -cp=path_to_file/conn.properties -hf=path_to_file/input_source_file.csv -hef=path_to_file/input_exception_file.csv "
			+ "\n\t Usage:"
			+ "\n -cp Required. Path to the database connection properties file. It needs to be in java properties format."
			+ "\n -hf Optional. Path to the hazardous to handle source file. It needs to be in CSV format."
	        + "\n -u Optional. Username to use to populate the last_modified_by field on the .";

	private static Arguments arguments;

	public static void main(String[] args) {
		arguments = new Arguments();

		Log.i("Loader started.");
		if (!arguments.isValid(args)) {
			// Show error message and exit
			Log.e(BAD_ARGUMENTS);
			System.exit(0);
		}

		Log.i("All updated rows will be marked with LAST_MODIFIED_BY = " + arguments.getLastUpdateUser());
		
		Log.d("Running Hazardous Waste Update. ");
		
		if (arguments.getInputFile() != null
				&& arguments.getInputExceptionFile() != null) {
			Log.d("Running hazardous waste parser");
			hazardousWaste();
		}
		
		Log.i("Loader complete.");
	}

    public static Properties getConnectionProperties(
			String connectionPropertiesFilename) {
		File connectionPropertiesFile = new File(connectionPropertiesFilename);
		Properties prop = new Properties();
		InputStream input = null;
		if (connectionPropertiesFile.exists()) {
			try {
				input = new FileInputStream(connectionPropertiesFile);
				prop.load(input);
			} catch (Throwable e) {
				Log.d("Error loading connection properties file. Please confirm file: "
						+ arguments.getConnProperties() + " exists.");
				System.exit(0);
			}
		}
		return prop;
	}

	public static void hazardousWaste() {

		File inputFile = new File(arguments.getInputFile());
		if (!inputFile.exists()) {
			Log.e("input file cannot be found: " + arguments.getInputFile());
			System.exit(0);
		}

		File inputExceptionFile = new File(arguments.getInputExceptionFile());
		if (!inputExceptionFile.exists()) {
			try {
				inputExceptionFile.createNewFile();
			} catch (Throwable e) {
				Log.d("Error creating VA_PRODUCT_OUTPUT_EXCEPTION_FILE: "
						+ arguments.getInputExceptionFile());
			}
		}

		IHazardousParser hazardousParser = new HazardousWasteParser(
				getConnectionProperties(arguments.getConnProperties()));
		try {
			hazardousParser.parse(inputFile, inputExceptionFile, arguments.getLastUpdateUser());
		} catch (HazardousParserException e) {
			Log.e("*** ERROR *** Hazardous Waste update using source file: "
					+ arguments.getInputFile());
		}
	}	
	
}
