package gov.va.med.mhv.vitals.web.controller;

import gov.va.med.mhv.vitals.dto.ResponseUtil;
import gov.va.med.mhv.vitals.web.form.bean.BloodPressureReading;
import gov.va.med.mhv.vitals.web.form.bean.BloodSugarReading;
import gov.va.med.mhv.vitals.web.form.bean.BodyTemperatureReading;
import gov.va.med.mhv.vitals.web.form.bean.BodyWeightReading;
import gov.va.med.mhv.vitals.web.form.bean.HeartRateReading;
import gov.va.med.mhv.vitals.web.form.bean.InrReading;
import gov.va.med.mhv.vitals.web.form.bean.LipidsReading;
import gov.va.med.mhv.vitals.web.form.bean.PainReading;
import gov.va.med.mhv.vitals.web.form.bean.PulseOximetryReading;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

@ManagedBean
@Component
@Scope("session")
public class VitalsController  extends AbstractController{
	private static final long serialVersionUID = -4834598324705181876L;
	private static Logger log = LogManager.getLogger(VitalsController.class);
	private List<BloodPressureReading> bpreadings = new ArrayList<BloodPressureReading>();
	private List<BloodSugarReading> bsreadings = new ArrayList<BloodSugarReading>();
	private List<BodyTemperatureReading> tempreadings = new ArrayList<BodyTemperatureReading>();
	private List<BodyWeightReading> bwreadings = new ArrayList<BodyWeightReading>();
	private List<HeartRateReading> hrreadings = new ArrayList<HeartRateReading>();
	private List<InrReading> inrreadings = new ArrayList<InrReading>();
	private List<LipidsReading> lpreadings = new ArrayList<LipidsReading>();
	private List<PainReading> painReadings = new ArrayList<PainReading>();
	private List<PulseOximetryReading> poreadings = new ArrayList<PulseOximetryReading>();
	private static final String PULSE_OXIMETRY="dashboardpo";
	private static final String PAIN="dashboardpain";
	private static final String LIPIDS="dashboardlp";
	private static final String INR="dashboardinr";
	private static final String HEART_RATE="dashboardhr";
	private static final String BODY_WEIGHT="dashboardbw";
	private static final String BODY_TEMPERATURE="dashboardbt";
	private static final String BLOOD_SUGAR="dashboardbs";
	private static final String BLOOD_PRESSURE="dashboardbp";
	
	
	
	public void init(ComponentSystemEvent event) {
		findUser();
		Long userprofileId = getUserProfileId();
		Reader responseReader=null;
		try{
		   if (userprofileId != null) {
			   bpreadings = findBloodPressureReadings(userprofileId,responseReader);
			   bsreadings=findBloodSugarReadings(userprofileId,responseReader);
			   tempreadings=findTemperatureReadings(userprofileId,responseReader);
			   bwreadings=findBodyWeightReadings(userprofileId,responseReader);
			   hrreadings=findHeartRateReadings(userprofileId,responseReader);
			   inrreadings=findINRReadings(userprofileId,responseReader);
			   lpreadings=findLipidsProfileReadings(userprofileId,responseReader);
			   painReadings=findPainReadings(userprofileId,responseReader);
			   poreadings=findPulseOximetryReadins(userprofileId,responseReader);
			}
		}catch (Exception e){
			log.error(e);
			
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
	}


	private List<PulseOximetryReading> findPulseOximetryReadins(Long userprofileId,Reader responseReader) {
		List<PulseOximetryReading> dtoList = null;
		Gson gson = getGson();
	    WebClient client= getWebClient().path(PULSE_OXIMETRY).path(userprofileId).accept(CONTENT_TYPE);
		responseReader = new InputStreamReader((InputStream) client.get().getEntity());
		ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
		if (response.isSuccess()) {
			String poReadingsJson = gson.toJson(response.getPojoObject());
			Type type = new TypeToken<List<PulseOximetryReading>>() {}.getType();
			dtoList = gson.fromJson(poReadingsJson, type);
			
			log.debug("Pulse oximetry Readings :" + dtoList.size());
		} else {
			log.error("Error in Find Pulse oximetry readings");
			throw new RuntimeException(response.getFailureMessage());
		}
		return dtoList;
	}


	private List<PainReading> findPainReadings(Long userprofileId,Reader responseReader) {
		List<PainReading> dtoList = null;
		Gson gson = getGson();
	    WebClient client= getWebClient().path(PAIN).path(userprofileId).accept(CONTENT_TYPE);
		responseReader = new InputStreamReader((InputStream) client.get().getEntity());
		ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
		if (response.isSuccess()) {
			String painreadingsJson = gson.toJson(response.getPojoObject());
			Type type = new TypeToken<List<PainReading>>() {}.getType();
			dtoList = gson.fromJson(painreadingsJson, type);
			
			log.debug("Pain Readings :" + dtoList.size());
		} else {
			log.error("Error in Find Pain readings");
			throw new RuntimeException(response.getFailureMessage());
		}
		return dtoList;
	}


	private List<LipidsReading> findLipidsProfileReadings(Long userprofileId,Reader responseReader) {
		List<LipidsReading> dtoList = null;
		Gson gson = getGson();
	    WebClient client= getWebClient().path(LIPIDS).path(userprofileId).accept(CONTENT_TYPE);
		responseReader = new InputStreamReader((InputStream) client.get().getEntity());
		ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
		if (response.isSuccess()) {
			String lpReadingsJson = gson.toJson(response.getPojoObject());
			Type type = new TypeToken<List<LipidsReading>>() {}.getType();
			dtoList = gson.fromJson(lpReadingsJson, type);
			
			log.debug("Lipid Readings :" + dtoList.size());
		} else {
			log.error("Error in Find Lipid readings");
			throw new RuntimeException(response.getFailureMessage());
		}
		return dtoList;
	}


	private List<InrReading> findINRReadings(Long userprofileId,Reader responseReader) {
		List<InrReading> dtoList = null;
		Gson gson = getGson();
	    WebClient client= getWebClient().path(INR).path(userprofileId).accept(CONTENT_TYPE);
		responseReader = new InputStreamReader((InputStream) client.get().getEntity());
		ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
		if (response.isSuccess()) {
			String inrReadingsJson = gson.toJson(response.getPojoObject());
			Type type = new TypeToken<List<InrReading>>() {}.getType();
			dtoList = gson.fromJson(inrReadingsJson, type);
			
			log.debug("INR Readings :" + dtoList.size());
		} else {
			log.error("Error in Find INR readings");
			throw new RuntimeException(response.getFailureMessage());
		}
		return dtoList;
	}


	private List<HeartRateReading> findHeartRateReadings(Long userprofileId,Reader responseReader) {
		List<HeartRateReading> dtoList = null;
		Gson gson = getGson();
	    WebClient client= getWebClient().path(HEART_RATE).path(userprofileId).accept(CONTENT_TYPE);
		responseReader = new InputStreamReader((InputStream) client.get().getEntity());
		ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
		if (response.isSuccess()) {
			String hrReadingsJson = gson.toJson(response.getPojoObject());
			Type type = new TypeToken<List<HeartRateReading>>() {}.getType();
			dtoList = gson.fromJson(hrReadingsJson, type);
			
			log.debug("Heartrate Readings :" + dtoList.size());
		} else {
			log.error("Error in Find Heartrate readings");
			throw new RuntimeException(response.getFailureMessage());
		}
		return dtoList;
	}


	private List<BodyWeightReading> findBodyWeightReadings(Long userprofileId,Reader responseReader) {
		List<BodyWeightReading> dtoList = null;
		Gson gson = getGson();
	    WebClient client= getWebClient().path(BODY_WEIGHT).path(userprofileId).accept(CONTENT_TYPE);
		responseReader = new InputStreamReader((InputStream) client.get().getEntity());
		ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
		if (response.isSuccess()) {
			String bwReadingsJson = gson.toJson(response.getPojoObject());
			Type type = new TypeToken<List<BodyWeightReading>>() {}.getType();
			dtoList = gson.fromJson(bwReadingsJson, type);
			
			log.debug("Bodyweight Readings :" + dtoList.size());
		} else {
			log.error("Error in Find Bodyweight readings");
			throw new RuntimeException(response.getFailureMessage());
		}
		return dtoList;
	}


	private List<BodyTemperatureReading> findTemperatureReadings(Long userprofileId,Reader responseReader) {
		List<BodyTemperatureReading> dtoList = null;
		Gson gson = getGson();
	    WebClient client= getWebClient().path(BODY_TEMPERATURE).path(userprofileId).accept(CONTENT_TYPE);
		responseReader = new InputStreamReader((InputStream) client.get().getEntity());
		ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
		if (response.isSuccess()) {
			String tempReadingsJson = gson.toJson(response.getPojoObject());
			Type type = new TypeToken<List<BodyTemperatureReading>>() {}.getType();
			dtoList = gson.fromJson(tempReadingsJson, type);
			
			log.debug("Temperature Readings :" + dtoList.size());
		} else {
			log.error("Error in Find Temperature  readings");
			throw new RuntimeException(response.getFailureMessage());
		}
		return dtoList;
	}


	private List<BloodSugarReading> findBloodSugarReadings(Long userprofileId,Reader responseReader) {
		List<BloodSugarReading> dtoList = null;
	
			Gson gson = getGson();
		    WebClient client= getWebClient().path(BLOOD_SUGAR).path(userprofileId).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String bsReadingsJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<BloodSugarReading>>() {}.getType();
				dtoList = gson.fromJson(bsReadingsJson, type);
				
				log.debug("Blood Sugar Readings :" + dtoList.size());
			} else {
				log.error("Error in Find Blood Sugar readings");
				throw new RuntimeException(response.getFailureMessage());
			}
		return dtoList;
	}

	private List<BloodPressureReading> findBloodPressureReadings(Long userprofileId, Reader responseReader) {
		List<BloodPressureReading> dtoList = null;
		Gson gson = getGson();
	    WebClient client= getWebClient().path(BLOOD_PRESSURE).path(userprofileId).accept(CONTENT_TYPE);
		responseReader = new InputStreamReader((InputStream) client.get().getEntity());
		ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
		if (response.isSuccess()) {
			String bpReadingsJson = gson.toJson(response.getPojoObject());
			Type type = new TypeToken<List<BloodPressureReading>>() {}.getType();
			dtoList = gson.fromJson(bpReadingsJson, type);
			
			log.debug("Bp Readings :" + dtoList.size());
		} else {
			log.error("Error in Find BP readings");
			throw new RuntimeException(response.getFailureMessage());
		}
		return dtoList;
	}


	public List<BloodPressureReading> getBpreadings() {
		return bpreadings;
	}


	public void setBpreadings(List<BloodPressureReading> bpreadings) {
		this.bpreadings = bpreadings;
	}


	public List<BloodSugarReading> getBsreadings() {
		return bsreadings;
	}


	public void setBsreadings(List<BloodSugarReading> bsreadings) {
		this.bsreadings = bsreadings;
	}


	public List<BodyTemperatureReading> getTempreadings() {
		return tempreadings;
	}


	public void setTempreadings(List<BodyTemperatureReading> tempreadings) {
		this.tempreadings = tempreadings;
	}


	public List<BodyWeightReading> getBwreadings() {
		return bwreadings;
	}


	public void setBwreadings(List<BodyWeightReading> bwreadings) {
		this.bwreadings = bwreadings;
	}


	public List<HeartRateReading> getHrreadings() {
		return hrreadings;
	}


	public void setHrreadings(List<HeartRateReading> hrreadings) {
		this.hrreadings = hrreadings;
	}


	public List<InrReading> getInrreadings() {
		return inrreadings;
	}


	public void setInrreadings(List<InrReading> inrreadings) {
		this.inrreadings = inrreadings;
	}


	public List<LipidsReading> getLpreadings() {
		return lpreadings;
	}


	public void setLpreadings(List<LipidsReading> lpreadings) {
		this.lpreadings = lpreadings;
	}


	public List<PainReading> getPainReadings() {
		return painReadings;
	}


	public void setPainReadings(List<PainReading> painReadings) {
		this.painReadings = painReadings;
	}


	public List<PulseOximetryReading> getPoreadings() {
		return poreadings;
	}


	public void setPoreadings(List<PulseOximetryReading> poreadings) {
		this.poreadings = poreadings;
	}
}
