package gov.va.med.mhv.vitals.web.controller;

import gov.va.med.mhv.vitals.dto.ResponseUtil;
import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;
import gov.va.med.mhv.vitals.web.form.bean.PulseOximetryReading;
import gov.va.med.mhv.vitals.web.util.WebUtility;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

@ManagedBean
@Component
@Scope("session")
public class PulseOximetryController extends AbstractController{

	private static final long serialVersionUID = -7820928514536173243L;
	
	private static Logger log = LogManager.getLogger(PulseOximetryController.class);
	private List<PulseOximetryReading> poreadings = new ArrayList<PulseOximetryReading>();
	private DataTable poTable;
	private PulseOximetryReading selectedPOReading = new PulseOximetryReading();
	private PulseOximetryReading newPOReading = new PulseOximetryReading();
	private static final String  TITLE ="Pulse Oximetry";
	private static final String  XAXIS ="Date";
	private static final String  YAXIS ="percentage";
	private static final String PULSE_OXIMETRY="pulseOximetry";
	private static final String DELETE_PO_READING="deletePOReading";
	private static final String PO_BY_ID="poreadingByid";

	

	public void init(ComponentSystemEvent event) {
		findUser();
		Long userprofileId = getUserProfileId();
		if (userprofileId != null) {
			poreadings = findPOReadings(userprofileId);
		}
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			setPeriod(PeriodEnumeration.ONE_MONTH.getDescription());
		}
	}


	private List<PulseOximetryReading> findPOReadings(Long userprofileId) {
		List<PulseOximetryReading> dtoList = null;
		Reader responseReader =null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(PULSE_OXIMETRY).path(userprofileId).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String poReadingsJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<PulseOximetryReading>>() {}.getType();
				dtoList = gson.fromJson(poReadingsJson, type);
				
				log.debug("Pulse oximetry Readings :" + dtoList.size());
			} else {
				log.error("Error in Find Pulse oximetry readings");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find Pulse oximetry readings:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dtoList;
	}

	public String showDetail() {
		resetMessages();
		selectedPOReading = (PulseOximetryReading) poTable.getRowData();
		setHourMinute(selectedPOReading);
		return "pulseOximetry";
	}
	
	public String editDisplay() {
		resetMessages();
		selectedPOReading = (PulseOximetryReading) poTable.getRowData();
		setHourMinute(selectedPOReading);
		return "editPODisplay";
	}

	public String deleteDisplay() {
		resetMessages();
		selectedPOReading = (PulseOximetryReading) poTable.getRowData();
		setHourMinute(selectedPOReading);
		return "deletePODisplay";
	}
	
	private void setHourMinute(PulseOximetryReading  selectedPOReading){
		String dateTime =WebUtility.dateToString(selectedPOReading.getReading(),HOUR_MINUTE);
		if(!dateTime.equals(DEFAULT_DATETIME)){
			selectedPOReading.setHour(WebUtility.dateToString(selectedPOReading.getReading(), HOURS));
			selectedPOReading.setMinute(WebUtility.dateToString(selectedPOReading.getReading(), MINUTES));
		}

	}

	public String addDisplay() {
		resetMessages();
		newPOReading=new PulseOximetryReading();
		newPOReading.setReading(new Date());
		return "addPODisplay";
	}
	
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newPOReading=new PulseOximetryReading();
		newPOReading.setReading(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../pulseoximetry/addPODisplay.xhtml");
		return null;
	}

	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String poid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("poid");
		if (poid != null) {
			Long id = Long.valueOf(poid);
			selectedPOReading=getPOReadingById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../pulseoximetry/pulseOximetry.xhtml");
		return null;
	}

	
	private PulseOximetryReading getPOReadingById(Long id) {
		PulseOximetryReading dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(PO_BY_ID).path(id).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String poReadingsJson = gson.toJson(response.getPojoObject());
				dto = gson.fromJson(poReadingsJson, PulseOximetryReading.class);
			} else {
				log.error("Error in Find PO reading By id");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find PO reading By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			
		}
		return dto;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String poid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("poid");
		try{
			if (poid != null) {
				Long id = Long.valueOf(poid);
				Gson gson = getGson();
				WebClient client=getWebClient().path(DELETE_PO_READING).path(id).accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete Pulse Oximetry Record" , response.getFailureMessage());
					
					FacesContext.getCurrentInstance().addMessage(null, 
							new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
				}else{
					deleteMessage = true;
					outcome="pulseOximetryList";
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete Pulse Oximetry record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		try{
			ResponseUtil response =savePOReading();
			if(response.isSuccess()){
				outcome="pulseOximetryList";
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save HeartRate record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}

	public ResponseUtil savePOReading() {
		
		String poid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("poid");
		Long id=null;
		PulseOximetryReading poreading=null;
		if (poid != null) {
			id = Long.valueOf(poid);
			poreading=getSelectedPOReading();
		}else{
			poreading=getNewPOReading();
		}
		Gson gson = getGsonTimeMilli();
		WebClient client= getWebClient().path(PULSE_OXIMETRY).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		poreading = preparePOReading(id,poreading);
		String hrJson = gson.toJson(poreading);
		Reader responseReader = new InputStreamReader((InputStream) client.post(hrJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
		if(!response.isSuccess()){
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
		return response;
	}

	private PulseOximetryReading preparePOReading(Long id,PulseOximetryReading poreading) {
		Date dateTime=null;
		if(poreading.getReading() != null ){
			if(poreading.getHour() == null  && poreading.getMinute() == null){
			   dateTime = WebUtility.getDaTeTime(poreading.getReading(), DEFAULT_HOUR, DEFAULT_MINUTE);
			}else{
			   dateTime = WebUtility.getDaTeTime(poreading.getReading(), poreading.getHour(), poreading.getMinute());	
			}
		}
		poreading.setReading(dateTime);
		poreading.setUserprofileId(getUserProfileId());
		return poreading;
	}

	public String saveAndAdd() {
		String outcome=null;
		try{
			ResponseUtil response=savePOReading();
			if(response.isSuccess()){
				outcome="addPODisplay";
				saveAndAddMessage = true;
				newPOReading=new PulseOximetryReading();
				newPOReading.setReading(new Date());
			}

		}catch(Exception e){
			log.error("Failed to Save Pulse oximetry record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}
	
	
	public String updateLineModel(){
        return "pulseOximetryGraph";
	}
	
	
	public StreamedContent getJchart(){
		StreamedContent content=null;
		try{
			content =createChart(TITLE,XAXIS,YAXIS);
		}catch(Exception e){
			log.error("Failed to create Chart",e);
		}
		return content;
	}
	
	protected XYDataset createDataset(Set<String> uniqueYears) {
		 TimeSeriesCollection dataset = new TimeSeriesCollection();
		 TimeSeries series1 = new TimeSeries(YAXIS);
		 String period = getPeriod();
		 Date startDate=null;
		 List<PulseOximetryReading> graphList;
		 if(!period.equals(PeriodEnumeration.ALL_DATA.getDescription())){
		     startDate =getStartGraphDate(period);
		 }
		 if(startDate != null){
		     graphList = getGraphlist(poreadings,startDate);
		 }else{
		     graphList = poreadings;
		 }
	     for( PulseOximetryReading poreading : graphList){
	    	 series1.addOrUpdate(new Day(poreading.getReading()),poreading.getOximeterReading());
		     uniqueYears.add(CommonUtility.dateToString(poreading.getReading(),YYYY_MM_DD_HHMMSS_FORMAT).substring(0,4));
	     }
		 dataset.addSeries(series1);
		 return dataset;
	}

	
	private List<PulseOximetryReading> getGraphlist(List<PulseOximetryReading> poreadings, Date startDate) {
		List<PulseOximetryReading> graphList= new ArrayList<PulseOximetryReading>();
		Integer startdateValue = Integer.valueOf(CommonUtility.dateToString(startDate, YYYYMMDD_FORMAT));
		for(PulseOximetryReading poreading : poreadings){
			Integer readingValue =Integer.valueOf(CommonUtility.dateToString(poreading.getReading(), YYYYMMDD_FORMAT));
			if(readingValue >= startdateValue){
				graphList.add(poreading);
			}
		}
		return graphList;
	}


	public List<PulseOximetryReading> getPoreadings() {
		return poreadings;
	}


	public void setPoreadings(List<PulseOximetryReading> poreadings) {
		this.poreadings = poreadings;
	}


	public DataTable getPoTable() {
		return poTable;
	}


	public void setPoTable(DataTable poTable) {
		this.poTable = poTable;
	}


	public PulseOximetryReading getSelectedPOReading() {
		return selectedPOReading;
	}


	public void setSelectedPOReading(PulseOximetryReading selectedPOReading) {
		this.selectedPOReading = selectedPOReading;
	}


	public PulseOximetryReading getNewPOReading() {
		return newPOReading;
	}


	public void setNewPOReading(PulseOximetryReading newPOReading) {
		this.newPOReading = newPOReading;
	}


	public static String getXaxis() {
		return XAXIS;
	}


	public static String getYaxis() {
		return YAXIS;
	}

}
