package gov.va.med.mhv.vitals.web.controller;

import gov.va.med.mhv.vitals.dto.ResponseUtil;
import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;
import gov.va.med.mhv.vitals.web.form.bean.PainReading;
import gov.va.med.mhv.vitals.web.util.WebUtility;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

@ManagedBean
@Component
@Scope("session")
public class PainController extends AbstractController {
	
	private static final long serialVersionUID = 5666598826183015313L;
	
	private static Logger log = LogManager.getLogger(PainController.class);
	private List<PainReading> painReadings = new ArrayList<PainReading>();
	private DataTable painTable;
	private PainReading selectedPainReading = new PainReading();
	private PainReading newPainreading = new PainReading();
	private static final String  TITLE ="Pain";
	private static final String  XAXIS ="Date";
	private static final String  YAXIS ="Degrees(F)";
	private static final String PAIN="pain";
	private static final String DELETE_PAIN_READING="deletePainReading";
	private static final String PAIN_BY_ID="painreadingByid";
	
	


	
	public void init(ComponentSystemEvent event) {
		findUser();
		Long userprofileId = getUserProfileId();
		if (userprofileId != null) {
			painReadings = findPainReadings(userprofileId);
		}
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			setPeriod(PeriodEnumeration.ONE_MONTH.getDescription());
		}
	}


	private List<PainReading> findPainReadings(Long userprofileId) {
		List<PainReading> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(PAIN).path(userprofileId).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String painreadingsJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<PainReading>>() {}.getType();
				dtoList = gson.fromJson(painreadingsJson, type);
				
				log.debug("Pain Readings :" + dtoList.size());
			} else {
				log.error("Error in Find Pain readings");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,	ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find Pain readings:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,	ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dtoList;
	}

	public String showDetail() {
		resetMessages();
		selectedPainReading = (PainReading) painTable.getRowData();
		setHourMinute(selectedPainReading);
		return "pain";
	}
	
	public String editDisplay() {
		resetMessages();
		selectedPainReading = (PainReading) painTable.getRowData();
		setHourMinute(selectedPainReading);
		return "editPainDisplay";
	}

	public String deleteDisplay() {
		resetMessages();
		selectedPainReading = (PainReading) painTable.getRowData();
		setHourMinute(selectedPainReading);
		return "deletePainDisplay";
	}
	
	private void setHourMinute(PainReading  selectedPainReading){
		String dateTime =WebUtility.dateToString(selectedPainReading.getReading(),HOUR_MINUTE);
		if(!dateTime.equals(DEFAULT_DATETIME)){
			selectedPainReading.setHour(WebUtility.dateToString(selectedPainReading.getReading(), HOURS));
			selectedPainReading.setMinute(WebUtility.dateToString(selectedPainReading.getReading(), MINUTES));
		}

	}

	public String addDisplay() {
		resetMessages();
		newPainreading=new PainReading();
		newPainreading.setReading(new Date());
		return "addPainDisplay";
	}
	
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newPainreading=new PainReading();
		newPainreading.setReading(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../pain/addPainDisplay.xhtml");
		return null;
	}

	
	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String painid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("painid");
		if (painid != null) {
			Long id = Long.valueOf(painid);
			selectedPainReading=getPaindReadingById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../pain/pain.xhtml");
		return null;
	}

	
	private PainReading getPaindReadingById(Long id) {
		PainReading dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(PAIN_BY_ID).path(id).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String painReadingJson = gson.toJson(response.getPojoObject());
				dto = gson.fromJson(painReadingJson, PainReading.class);
			} else {
				log.error("Error in Find Pain reading By id");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find Pain reading By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dto;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String painid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("painid");
		try{
			if (painid != null) {
				Long id = Long.valueOf(painid);
				Gson gson = getGson();
				WebClient client=getWebClient().path(DELETE_PAIN_READING).path(id).accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete Pain Record" , response.getFailureMessage());
					
					FacesContext.getCurrentInstance().addMessage(null, 
							new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
				}else{
					deleteMessage = true;
					outcome="painList";
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete Pain record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		try{
			ResponseUtil response =savePainReading();
			if(response.isSuccess()){
				outcome="painList";
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save Pain record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}

	public ResponseUtil savePainReading() {
		
		String painid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("painid");
		Long id=null;
		PainReading painReading=null;
		if (painid != null) {
			id = Long.valueOf(painid);
			painReading=getSelectedPainReading();
		}else{
			painReading=getNewPainreading();
		}
		Gson gson = getGsonTimeMilli();
		WebClient client= getWebClient().path(PAIN).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		painReading = preparePainReading(id,painReading);
		String bpJson = gson.toJson(painReading);
		Reader responseReader = new InputStreamReader((InputStream) client.post(bpJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
		if(!response.isSuccess()){
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
		return response;
	}

	private PainReading preparePainReading(Long id,PainReading painReading) {
		Date dateTime=null;
		if(painReading.getReading() != null ){
			if(painReading.getHour() == null  && painReading.getMinute() == null){
			   dateTime = WebUtility.getDaTeTime(painReading.getReading(), DEFAULT_HOUR, DEFAULT_MINUTE);
			}else{
			   dateTime = WebUtility.getDaTeTime(painReading.getReading(), painReading.getHour(), painReading.getMinute());	
			}
		}
		painReading.setReading(dateTime);
		painReading.setUserprofileId(getUserProfileId());
		return painReading;
	}

	public String saveAndAdd() {
		String outcome=null;
		try{
			ResponseUtil response=savePainReading();
			if(response.isSuccess()){
				outcome="addPainDisplay";
				saveAndAddMessage = true;
				newPainreading=new PainReading();
				newPainreading.setReading(new Date());
			}

		}catch(Exception e){
			log.error("Failed to Save Pain record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST,ERR_PRCS_RQST));
		}
		return outcome;
	}
	
	public String updateLineModel(){
        return "painGraph";
	}
	
	
	public StreamedContent getJchart(){
		StreamedContent content=null;
		try{
			content =createChart(TITLE,XAXIS,YAXIS);
		}catch(Exception e){
			log.error("Failed to create Chart",e);
		}
		return content;
	}
	
	
	protected XYDataset createDataset(Set<String> uniqueYears) {
		 TimeSeriesCollection dataset = new TimeSeriesCollection();
		 TimeSeries series1 = new TimeSeries(YAXIS);
		 String period = getPeriod();
		 Date startDate=null;
		 List<PainReading> graphList;
		 if(!period.equals(PeriodEnumeration.ALL_DATA.getDescription())){
		     startDate =getStartGraphDate(period);
		 }
		 if(startDate != null){
		     graphList = getGraphlist(painReadings,startDate);
		 }else{
		     graphList = painReadings;
		 }
	     for( PainReading reading : graphList){
	    	 series1.addOrUpdate(new Day(reading.getReading()),reading.getPainLevel());
		     uniqueYears.add(CommonUtility.dateToString(reading.getReading(),YYYY_MM_DD_HHMMSS_FORMAT).substring(0,4));
	     }
		 dataset.addSeries(series1);
		 return dataset;
	}
	
	


	private List<PainReading> getGraphlist(List<PainReading> painReadings, Date startDate) {
		List<PainReading> graphList= new ArrayList<PainReading>();
		Integer startdateValue = Integer.valueOf(CommonUtility.dateToString(startDate, YYYYMMDD_FORMAT));
		for(PainReading painReading : painReadings){
			Integer readingValue =Integer.valueOf(CommonUtility.dateToString(painReading.getReading(), YYYYMMDD_FORMAT));
			if(readingValue >= startdateValue){
				graphList.add(painReading);
			}
		}
		return graphList;
	}


	public List<PainReading> getPainReadings() {
		return painReadings;
	}


	public void setPainReadings(List<PainReading> painReadings) {
		this.painReadings = painReadings;
	}


	public DataTable getPainTable() {
		return painTable;
	}


	public void setPainTable(DataTable painTable) {
		this.painTable = painTable;
	}


	public PainReading getSelectedPainReading() {
		return selectedPainReading;
	}


	public void setSelectedPainReading(PainReading selectedPainReading) {
		this.selectedPainReading = selectedPainReading;
	}


	public PainReading getNewPainreading() {
		return newPainreading;
	}


	public void setNewPainreading(PainReading newPainreading) {
		this.newPainreading = newPainreading;
	}


}
