package gov.va.med.mhv.vitals.web.controller;

import gov.va.med.mhv.vitals.dto.ResponseUtil;
import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;
import gov.va.med.mhv.vitals.web.form.bean.LipidsReading;
import gov.va.med.mhv.vitals.web.util.WebUtility;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

@ManagedBean
@Component
@Scope("session")
public class LipidsController extends AbstractController{
	
	private static final long serialVersionUID = 134538500296925325L;
	private static Logger log = LogManager.getLogger(LipidsController.class);
	private List<LipidsReading> lpreadings = new ArrayList<LipidsReading>();
	private DataTable lpTable;
	private LipidsReading selectedLPReading = new LipidsReading();
	private LipidsReading newLPReading = new LipidsReading();
	private static final String  TITLE ="Cholesterol (Lipids Profile)";
	private static final String  XAXIS ="Date";
	private static final String  YAXIS ="mg/dL";
	private static final String  SERIES1="Total";
	private static final String  SERIES2="HDL";
	private static final String  SERIES3="LDL";
	private static final String  SERIES4="TGL";
	private static final String LIPIDS="lipids";
	private static final String DELETE_LP_READING="deleteLPReading";
	private static final String LIPID_BY_ID="lpreadingByid";
	
	


	


	public void init(ComponentSystemEvent event) {
		findUser();
		Long userprofileId = getUserProfileId();
		if (userprofileId != null) {
			lpreadings = findLPReadings(userprofileId);
		}
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			setPeriod(PeriodEnumeration.ONE_MONTH.getDescription());
		}
	}


	private List<LipidsReading> findLPReadings(Long userprofileId) {
		List<LipidsReading> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(LIPIDS).path(userprofileId).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String lpReadingsJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<LipidsReading>>() {}.getType();
				dtoList = gson.fromJson(lpReadingsJson, type);
				
				log.debug("Lipid Readings :" + dtoList.size());
			} else {
				log.error("Error in Find Lipid readings");
				
				FacesContext.getCurrentInstance().addMessage(null,
						 new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find Lipid readings:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					    new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dtoList;
	}

	public String showDetail() {
		resetMessages();
		selectedLPReading = (LipidsReading) lpTable.getRowData();
		setHourMinute(selectedLPReading);
		return "lipids";
	}
	
	public String editDisplay() {
		resetMessages();
		selectedLPReading = (LipidsReading) lpTable.getRowData();
		setHourMinute(selectedLPReading);
		return "editLPDisplay";
	}

	public String deleteDisplay() {
		resetMessages();
		selectedLPReading = (LipidsReading) lpTable.getRowData();
		setHourMinute(selectedLPReading);
		return "deleteLPDisplay";
	}
	
	private void setHourMinute(LipidsReading  selectedLPReading){
		String dateTime =WebUtility.dateToString(selectedLPReading.getReading(),HOUR_MINUTE);
		if(!dateTime.equals(DEFAULT_DATETIME)){
			selectedLPReading.setHour(WebUtility.dateToString(selectedLPReading.getReading(), HOURS));
			selectedLPReading.setMinute(WebUtility.dateToString(selectedLPReading.getReading(), MINUTES));
		}

	}

	public String addDisplay() {
		resetMessages();
		newLPReading=new LipidsReading();
		newLPReading.setReading(new Date());
		return "addLPDisplay";
	}
	
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newLPReading=new LipidsReading();
		newLPReading.setReading(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../lipidsprofile/addLPDisplay.xhtml");
		return null;
	}

	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String lpid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("lpid");
		if (lpid != null) {
			Long id = Long.valueOf(lpid);
			selectedLPReading=getLPReadingById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../lipidsprofile/lipids.xhtml");
		return null;
	}

	
	private LipidsReading getLPReadingById(Long id) {
		LipidsReading dto=null;
		Reader responseReader =null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(LIPID_BY_ID).path(id).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String lpReadingsJson = gson.toJson(response.getPojoObject());
				dto = gson.fromJson(lpReadingsJson, LipidsReading.class);
			} else {
				log.error("Error in Find LP reading By id");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find LP reading By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dto;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String lpid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("lpid");
		try{
			if (lpid != null) {
				Long id = Long.valueOf(lpid);
				Gson gson = getGson();
				WebClient client=getWebClient().path(DELETE_LP_READING).path(id).accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete Lipids Record" , response.getFailureMessage());
					
					FacesContext.getCurrentInstance().addMessage(null, 
							new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
				}else{
					deleteMessage = true;
					outcome="lipidsList";
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete Lipids record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		try{
			ResponseUtil response =saveLPReading();
			if(response.isSuccess()){
				outcome="lipidsList";
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save Lipids record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}

	public ResponseUtil saveLPReading() {
		
		String lpid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("lpid");
		Long id=null;
		LipidsReading lpreading=null;
		if (lpid != null) {
			id = Long.valueOf(lpid);
			lpreading=getSelectedLPReading();
		}else{
			lpreading=getNewLPReading();
		}
		Gson gson = getGsonTimeMilli();
		WebClient client= getWebClient().path(LIPIDS).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		lpreading = prepareLPReading(id,lpreading);
		String lpJson = gson.toJson(lpreading);
		Reader responseReader = new InputStreamReader((InputStream) client.post(lpJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
		if(!response.isSuccess()){
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
		return response;
	}

	private LipidsReading prepareLPReading(Long id,LipidsReading lpreading) {
		Date dateTime=null;
		if(lpreading.getReading() != null ){
			if(lpreading.getHour() == null  && lpreading.getMinute() == null){
			   dateTime = WebUtility.getDaTeTime(lpreading.getReading(), DEFAULT_HOUR, DEFAULT_MINUTE);
			}else{
			   dateTime = WebUtility.getDaTeTime(lpreading.getReading(), lpreading.getHour(), lpreading.getMinute());	
			}
		}
		lpreading.setReading(dateTime);
		lpreading.setUserprofileId(getUserProfileId());
		return lpreading;
	}

	public String saveAndAdd() {
		String outcome=null;
		try{
			ResponseUtil response=saveLPReading();
			if(response.isSuccess()){
				outcome="addLPDisplay";
				saveAndAddMessage = true;
				newLPReading=new LipidsReading();
				newLPReading.setReading(new Date());
			}

		}catch(Exception e){
			log.error("Failed to Save Lipids record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}
	
	
	public String updateLineModel(){
        return "lipidsGraph";
	}
	
	
	public StreamedContent getJchart(){
		StreamedContent content=null;
		try{
			content =createChart(TITLE,XAXIS,YAXIS);
		}catch(Exception e){
			log.error("Failed to create Chart",e);
		}
		return content;
	}
	
	protected XYDataset createDataset(Set<String> uniqueYears) {
		 TimeSeriesCollection dataset = new TimeSeriesCollection();
		 TimeSeries series1 = new TimeSeries(SERIES1);
		 TimeSeries series2 = new TimeSeries(SERIES2);
		 TimeSeries series3 = new TimeSeries(SERIES3);
		 TimeSeries series4 = new TimeSeries(SERIES4);
		 String period = getPeriod();
		 Date startDate=null;
		 List<LipidsReading> graphList;
		 if(!period.equals(PeriodEnumeration.ALL_DATA.getDescription())){
		     startDate =getStartGraphDate(period);
		 }
		 if(startDate != null){
		     graphList = getGraphlist(lpreadings,startDate);
		 }else{
		     graphList = lpreadings;
		 }
	     for( LipidsReading lpreading : graphList){
	    	 series1.addOrUpdate(new Day(lpreading.getReading()),lpreading.getTotal());
	    	 series2.addOrUpdate(new Day(lpreading.getReading()),lpreading.getHdl());
	    	 series3.addOrUpdate(new Day(lpreading.getReading()),lpreading.getLdl());
	    	 series4.addOrUpdate(new Day(lpreading.getReading()),lpreading.getTriglycerides());
		     uniqueYears.add(CommonUtility.dateToString(lpreading.getReading(),YYYY_MM_DD_HHMMSS_FORMAT).substring(0,4));
	     }
		 dataset.addSeries(series1);
		 dataset.addSeries(series2);
		 dataset.addSeries(series3);
		 dataset.addSeries(series4);
		 return dataset;
	}

	
	private List<LipidsReading> getGraphlist(List<LipidsReading> lpreadings, Date startDate) {
		List<LipidsReading> graphList= new ArrayList<LipidsReading>();
		Integer startdateValue = Integer.valueOf(CommonUtility.dateToString(startDate, YYYYMMDD_FORMAT));
		for(LipidsReading lpreading : lpreadings){
			Integer readingValue =Integer.valueOf(CommonUtility.dateToString(lpreading.getReading(), YYYYMMDD_FORMAT));
			if(readingValue >= startdateValue){
				graphList.add(lpreading);
			}
		}
		return graphList;
	}


	public List<LipidsReading> getLpreadings() {
		return lpreadings;
	}


	public void setLpreadings(List<LipidsReading> lpreadings) {
		this.lpreadings = lpreadings;
	}


	public DataTable getLpTable() {
		return lpTable;
	}


	public void setLpTable(DataTable lpTable) {
		this.lpTable = lpTable;
	}


	public LipidsReading getSelectedLPReading() {
		return selectedLPReading;
	}


	public void setSelectedLPReading(LipidsReading selectedLPReading) {
		this.selectedLPReading = selectedLPReading;
	}


	public LipidsReading getNewLPReading() {
		return newLPReading;
	}


	public void setNewLPReading(LipidsReading newLPReading) {
		this.newLPReading = newLPReading;
	}

}
