package gov.va.med.mhv.vitals.web.controller;

import gov.va.med.mhv.vitals.dto.ResponseUtil;
import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;
import gov.va.med.mhv.vitals.web.form.bean.InrReading;
import gov.va.med.mhv.vitals.web.util.WebUtility;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

@ManagedBean
@Component
@Scope("session")
public class InrController  extends AbstractController {
	
	private static final long serialVersionUID = 2890169291805333677L;
	private static Logger log = LogManager.getLogger(InrController.class);
	private List<InrReading> inrreadings = new ArrayList<InrReading>();
	private DataTable inrTable;
	private InrReading selectedINRReading = new InrReading();
	private InrReading newINRReading = new InrReading();
	private static final String  TITLE ="International Normalized Ratio (INR)";
	private static final String  XAXIS ="Date";
	private static final String  YAXIS ="International Normalized Ratio (INR) Value";
	private static final String INR="inr";
	private static final String DELETE_INR_READING="deleteInrReading";
	private static final String INR_BY_ID="inrreadingByid";
	
	
	public void init(ComponentSystemEvent event) {
		findUser();
		Long userprofileId = getUserProfileId();
		if (userprofileId != null) {
			inrreadings = findINRReadings(userprofileId);
		}
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			setPeriod(PeriodEnumeration.ONE_MONTH.getDescription());
		}
	}


	private List<InrReading> findINRReadings(Long userprofileId) {
		List<InrReading> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(INR).path(userprofileId).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String inrReadingsJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<InrReading>>() {}.getType();
				dtoList = gson.fromJson(inrReadingsJson, type);
				
				log.debug("INR Readings :" + dtoList.size());
			} else {
				log.error("Error in Find INR readings");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find INR readings:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,	ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dtoList;
	}

	public String showDetail() {
		resetMessages();
		selectedINRReading = (InrReading) inrTable.getRowData();
		setHourMinute(selectedINRReading);
		return "inr";
	}
	
	public String editDisplay() {
		resetMessages();
		selectedINRReading = (InrReading) inrTable.getRowData();
		setHourMinute(selectedINRReading);
		return "editINRDisplay";
	}

	public String deleteDisplay() {
		resetMessages();
		selectedINRReading = (InrReading) inrTable.getRowData();
		setHourMinute(selectedINRReading);
		return "deleteINRDisplay";
	}
	
	private void setHourMinute(InrReading  selectedINRReading){
		String dateTime =WebUtility.dateToString(selectedINRReading.getReading(),HOUR_MINUTE);
		if(!dateTime.equals(DEFAULT_DATETIME)){
			selectedINRReading.setHour(WebUtility.dateToString(selectedINRReading.getReading(), HOURS));
			selectedINRReading.setMinute(WebUtility.dateToString(selectedINRReading.getReading(), MINUTES));
		}

	}

	public String addDisplay() {
		resetMessages();
		newINRReading=new InrReading();
		newINRReading.setInr(new BigDecimal(new String("0.0")));
		newINRReading.setReading(new Date());
		return "addINRDisplay";
	}
	
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newINRReading=new InrReading();
		newINRReading.setInr(new BigDecimal(new String("0.0")));
		newINRReading.setReading(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../inr/addINRDisplay.xhtml");
		return null;
	}

	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String inrid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("inrid");
		if (inrid != null) {
			Long id = Long.valueOf(inrid);
			selectedINRReading=getINRReadingById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../inr/inr.xhtml");
		return null;
	}

	
	private InrReading getINRReadingById(Long id) {
		InrReading dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(INR_BY_ID).path(id).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String inrReadingsJson = gson.toJson(response.getPojoObject());
				dto = gson.fromJson(inrReadingsJson, InrReading.class);
			} else {
				log.error("Error in Find INR reading By id");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find INR reading By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dto;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String inrid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("inrid");
		try{
			if (inrid != null) {
				Long id = Long.valueOf(inrid);
				Gson gson = getGson();
				WebClient client=getWebClient().path(DELETE_INR_READING).path(id).accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete INR Record" , response.getFailureMessage());
					
					FacesContext.getCurrentInstance().addMessage(null, 
							new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
				}else{
					deleteMessage = true;
					outcome="inrList";
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete INR record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		try{
			ResponseUtil response =saveINRReading();
			if(response.isSuccess()){
				outcome="inrList";
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save INR record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}

	public ResponseUtil saveINRReading() {
		
		String inrid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("inrid");
		Long id=null;
		InrReading inrreading=null;
		if (inrid != null) {
			id = Long.valueOf(inrid);
			inrreading=getSelectedINRReading();
		}else{
			inrreading=getNewINRReading();
		}
		Gson gson = getGsonTimeMilli();
		WebClient client= getWebClient().path(INR).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		inrreading = prepareINRReading(id,inrreading);
		String inrJson = gson.toJson(inrreading);
		Reader responseReader = new InputStreamReader((InputStream) client.post(inrJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
		if(!response.isSuccess()){
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
		return response;
	}

	private InrReading prepareINRReading(Long id,InrReading inrreading) {
		Date dateTime=null;
		if(inrreading.getReading() != null ){
			if(inrreading.getHour() == null  && inrreading.getMinute() == null){
			   dateTime = WebUtility.getDaTeTime(inrreading.getReading(), DEFAULT_HOUR, DEFAULT_MINUTE);
			}else{
			   dateTime = WebUtility.getDaTeTime(inrreading.getReading(), inrreading.getHour(), inrreading.getMinute());	
			}
		}
		inrreading.setReading(dateTime);
		inrreading.setUserprofileId(getUserProfileId());
		return inrreading;
	}

	public String saveAndAdd() {
		String outcome=null;
		try{
			ResponseUtil response=saveINRReading();
			if(response.isSuccess()){
				outcome="addINRDisplay";
				saveAndAddMessage = true;
				newINRReading=new InrReading();
				newINRReading.setInr(new BigDecimal(new String("0.0")));
				newINRReading.setReading(new Date());
			}

		}catch(Exception e){
			log.error("Failed to Save HeartRate record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}
	
	
	public String updateLineModel(){
        return "inrGraph";
	}
	
	
	public StreamedContent getJchart(){
		StreamedContent content=null;
		try{
			content =createChart(TITLE,XAXIS,YAXIS);
		}catch(Exception e){
			log.error("Failed to create Chart",e);
		}
		return content;
	}
	
	protected XYDataset createDataset(Set<String> uniqueYears) {
		 TimeSeriesCollection dataset = new TimeSeriesCollection();
		 TimeSeries series1 = new TimeSeries(YAXIS);
		 String period = getPeriod();
		 Date startDate=null;
		 List<InrReading> graphList;
		 if(!period.equals(PeriodEnumeration.ALL_DATA.getDescription())){
		     startDate =getStartGraphDate(period);
		 }
		 if(startDate != null){
		     graphList = getGraphlist(inrreadings,startDate);
		 }else{
		     graphList = inrreadings;
		 }
	     for( InrReading inrreading : graphList){
	    	 series1.addOrUpdate(new Day(inrreading.getReading()),inrreading.getInr());
		     uniqueYears.add(CommonUtility.dateToString(inrreading.getReading(),YYYY_MM_DD_HHMMSS_FORMAT).substring(0,4));
	     }
		 dataset.addSeries(series1);
		 return dataset;
	}

	
	private List<InrReading> getGraphlist(List<InrReading> inrreadings, Date startDate) {
		List<InrReading> graphList= new ArrayList<InrReading>();
		Integer startdateValue = Integer.valueOf(CommonUtility.dateToString(startDate, YYYYMMDD_FORMAT));
		for(InrReading inrreading : inrreadings){
			Integer readingValue =Integer.valueOf(CommonUtility.dateToString(inrreading.getReading(), YYYYMMDD_FORMAT));
			if(readingValue >= startdateValue){
				graphList.add(inrreading);
			}
		}
		return graphList;
	}


	public List<InrReading> getInrreadings() {
		return inrreadings;
	}


	public void setInrreadings(List<InrReading> inrreadings) {
		this.inrreadings = inrreadings;
	}


	public DataTable getInrTable() {
		return inrTable;
	}


	public void setInrTable(DataTable inrTable) {
		this.inrTable = inrTable;
	}


	public InrReading getSelectedINRReading() {
		return selectedINRReading;
	}


	public void setSelectedINRReading(InrReading selectedINRReading) {
		this.selectedINRReading = selectedINRReading;
	}


	public InrReading getNewINRReading() {
		return newINRReading;
	}


	public void setNewINRReading(InrReading newINRReading) {
		this.newINRReading = newINRReading;
	}

	
}
