package gov.va.med.mhv.vitals.web.controller;

import gov.va.med.mhv.vitals.dto.ResponseUtil;
import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;
import gov.va.med.mhv.vitals.web.form.bean.HeartRateReading;
import gov.va.med.mhv.vitals.web.util.WebUtility;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;


@ManagedBean
@Component
@Scope("session")
public class HeartRateController extends AbstractController {
	
	private static final long serialVersionUID = 1589077815230808123L;
	private static Logger log = LogManager.getLogger(HeartRateController.class);
	private List<HeartRateReading> hrreadings = new ArrayList<HeartRateReading>();
	private DataTable hrTable;
	private HeartRateReading selectedHRReading = new HeartRateReading();
	private HeartRateReading newHRReading = new HeartRateReading();
	private static final String  TITLE ="Heart Rate";
	private static final String  XAXIS ="Date";
	private static final String  YAXIS ="BPM";
	private static final String HEART_RATE="heartrate";
	private static final String DELETE_HR_READING="deleteHRReading";
	private static final String HR_READING_BY_ID="hrreadingByid";
	
	

	
	
	
	public void init(ComponentSystemEvent event) {
		findUser();
		Long userprofileId = getUserProfileId();
		if (userprofileId != null) {
			hrreadings = findHRReadings(userprofileId);
		}
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			setPeriod(PeriodEnumeration.ONE_MONTH.getDescription());
		}
	}


	private List<HeartRateReading> findHRReadings(Long userprofileId) {
		List<HeartRateReading> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(HEART_RATE).path(userprofileId).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String hrReadingsJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<HeartRateReading>>() {}.getType();
				dtoList = gson.fromJson(hrReadingsJson, type);
				
				log.debug("Heartrate Readings :" + dtoList.size());
			} else {
				log.error("Error in Find Heartrate readings");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find Heartrate readings:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,	ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dtoList;
	}

	public String showDetail() {
		resetMessages();
		selectedHRReading = (HeartRateReading) hrTable.getRowData();
		setHourMinute(selectedHRReading);
		return "heartRate";
	}
	
	public String editDisplay() {
		resetMessages();
		selectedHRReading = (HeartRateReading) hrTable.getRowData();
		setHourMinute(selectedHRReading);
		return "editHRDisplay";
	}

	public String deleteDisplay() {
		resetMessages();
		selectedHRReading = (HeartRateReading) hrTable.getRowData();
		setHourMinute(selectedHRReading);
		return "deleteHRDisplay";
	}
	
	private void setHourMinute(HeartRateReading  selectedHRReading){
		String dateTime =WebUtility.dateToString(selectedHRReading.getReading(),HOUR_MINUTE);
		if(!dateTime.equals(DEFAULT_DATETIME)){
			selectedHRReading.setHour(WebUtility.dateToString(selectedHRReading.getReading(), HOURS));
			selectedHRReading.setMinute(WebUtility.dateToString(selectedHRReading.getReading(), MINUTES));
		}

	}

	public String addDisplay() {
		resetMessages();
		newHRReading=new HeartRateReading();
		newHRReading.setReading(new Date());
		return "addHRDisplay";
	}
	
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newHRReading=new HeartRateReading();
		newHRReading.setReading(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../heartrate/addHRDisplay.xhtml");
		return null;
	}

	
	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String hrid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("hrid");
		if (hrid != null) {
			Long id = Long.valueOf(hrid);
			selectedHRReading=getHRReadingById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../heartrate/heartRate.xhtml");
		return null;
	}

	
	private HeartRateReading getHRReadingById(Long id) {
		HeartRateReading dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(HR_READING_BY_ID).path(id).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String hrReadingsJson = gson.toJson(response.getPojoObject());
				dto = gson.fromJson(hrReadingsJson, HeartRateReading.class);
			} else {
				log.error("Error in Find HR reading By id");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find HR reading By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dto;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String hrid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("hrid");
		try{
			if (hrid != null) {
				Long id = Long.valueOf(hrid);
				Gson gson = getGson();
				WebClient client=getWebClient().path(DELETE_HR_READING).path(id).accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete HeartRate Record" , response.getFailureMessage());
					
					FacesContext.getCurrentInstance().addMessage(null, 
							new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
				}else{
					deleteMessage = true;
					outcome="heartRateList";
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete HeartRate record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		try{
			ResponseUtil response =saveHRReading();
			if(response.isSuccess()){
				outcome="heartRateList";
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save HeartRate record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}

	public ResponseUtil saveHRReading() {
		
		String hrid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("hrid");
		Long id=null;
		HeartRateReading hrreading=null;
		if (hrid != null) {
			id = Long.valueOf(hrid);
			hrreading=getSelectedHRReading();
		}else{
			hrreading=getNewHRReading();
		}
		Gson gson = getGsonTimeMilli();
		WebClient client= getWebClient().path(HEART_RATE).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		hrreading = prepareHRReading(id,hrreading);
		String hrJson = gson.toJson(hrreading);
		Reader responseReader = new InputStreamReader((InputStream) client.post(hrJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
		if(!response.isSuccess()){
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
		return response;
	}

	private HeartRateReading prepareHRReading(Long id,HeartRateReading hrreading) {
		Date dateTime=null;
		if(hrreading.getReading() != null ){
			if(hrreading.getHour() == null  && hrreading.getMinute() == null){
			   dateTime = WebUtility.getDaTeTime(hrreading.getReading(), DEFAULT_HOUR, DEFAULT_MINUTE);
			}else{
			   dateTime = WebUtility.getDaTeTime(hrreading.getReading(), hrreading.getHour(), hrreading.getMinute());	
			}
		}
		hrreading.setReading(dateTime);
		hrreading.setUserprofileId(getUserProfileId());
		return hrreading;
	}

	public String saveAndAdd() {
		String outcome=null;
		try{
			ResponseUtil response=saveHRReading();
			if(response.isSuccess()){
				outcome="addHRDisplay";
				saveAndAddMessage = true;
				newHRReading=new HeartRateReading();
				newHRReading.setReading(new Date());
			}

		}catch(Exception e){
			log.error("Failed to Save HeartRate record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}
	
	
	public String updateLineModel(){
        return "heartRateGraph";
	}
	
	
	public StreamedContent getJchart(){
		StreamedContent content=null;
		try{
			content =createChart(TITLE,XAXIS,YAXIS);
		}catch(Exception e){
			log.error("Failed to create Chart",e);
		}
		return content;
	}
	
	protected XYDataset createDataset(Set<String> uniqueYears) {
		 TimeSeriesCollection dataset = new TimeSeriesCollection();
		 TimeSeries series1 = new TimeSeries(YAXIS);
		 String period = getPeriod();
		 Date startDate=null;
		 List<HeartRateReading> graphList;
		 if(!period.equals(PeriodEnumeration.ALL_DATA.getDescription())){
		     startDate =getStartGraphDate(period);
		 }
		 if(startDate != null){
		     graphList = getGraphlist(hrreadings,startDate);
		 }else{
		     graphList = hrreadings;
		 }
	     for( HeartRateReading hrreading : graphList){
	    	 series1.addOrUpdate(new Day(hrreading.getReading()),hrreading.getHeartRate());
		     uniqueYears.add(CommonUtility.dateToString(hrreading.getReading(),YYYY_MM_DD_HHMMSS_FORMAT).substring(0,4));
	     }
		 dataset.addSeries(series1);
		 return dataset;
	}

	
	private List<HeartRateReading> getGraphlist(List<HeartRateReading> hreadings, Date startDate) {
		List<HeartRateReading> graphList= new ArrayList<HeartRateReading>();
		Integer startdateValue = Integer.valueOf(CommonUtility.dateToString(startDate, YYYYMMDD_FORMAT));
		for(HeartRateReading hreading : hreadings){
			Integer readingValue =Integer.valueOf(CommonUtility.dateToString(hreading.getReading(), YYYYMMDD_FORMAT));
			if(readingValue >= startdateValue){
				graphList.add(hreading);
			}
		}
		return graphList;
	}

	/**
	 * @return the hrreadings
	 */
	public List<HeartRateReading> getHrreadings() {
		return hrreadings;
	}


	/**
	 * @param hrreadings the hrreadings to set
	 */
	public void setHrreadings(List<HeartRateReading> hrreadings) {
		this.hrreadings = hrreadings;
	}


	/**
	 * @return the hrTable
	 */
	public DataTable getHrTable() {
		return hrTable;
	}


	/**
	 * @param hrTable the hrTable to set
	 */
	public void setHrTable(DataTable hrTable) {
		this.hrTable = hrTable;
	}


	/**
	 * @return the selectedHRReading
	 */
	public HeartRateReading getSelectedHRReading() {
		return selectedHRReading;
	}


	/**
	 * @param selectedHRReading the selectedHRReading to set
	 */
	public void setSelectedHRReading(HeartRateReading selectedHRReading) {
		this.selectedHRReading = selectedHRReading;
	}


	/**
	 * @return the newHRReading
	 */
	public HeartRateReading getNewHRReading() {
		return newHRReading;
	}


	/**
	 * @param newHRReading the newHRReading to set
	 */
	public void setNewHRReading(HeartRateReading newHRReading) {
		this.newHRReading = newHRReading;
	}

}
