package gov.va.med.mhv.vitals.web.controller;

import gov.va.med.mhv.vitals.dto.ResponseUtil;
import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;
import gov.va.med.mhv.vitals.web.form.bean.BodyWeightReading;
import gov.va.med.mhv.vitals.web.util.WebUtility;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;


@ManagedBean
@Component
@Scope("session")
public class BodyWeightController  extends AbstractController {

	private static final long serialVersionUID = -4411096279495705994L;
	private static Logger log = LogManager.getLogger(BodyWeightController.class);
	private List<BodyWeightReading> bwreadings = new ArrayList<BodyWeightReading>();
	private DataTable bwTable;
	private BodyWeightReading selectedBWReading = new BodyWeightReading();
	private BodyWeightReading newBWReading = new BodyWeightReading();
	private static final String  TITLE ="Body Weight";
	private static final String  XAXIS ="Date";
	private static final String  YAXIS ="lbs";
	private static final String BODY_WEIGHT="bodyweight";
	private static final String DELETE_BW_READING="deleteBWReading";
	private static final String BODY_WEIGHT_BY_ID="bwreadingByid";
	
	

	
	
	
	public void init(ComponentSystemEvent event) {
		findUser();
		Long userprofileId = getUserProfileId();
		if (userprofileId != null) {
			bwreadings = findBWReadings(userprofileId);
		}
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			setPeriod(PeriodEnumeration.ONE_MONTH.getDescription());
		}
	}


	private List<BodyWeightReading> findBWReadings(Long userprofileId) {
		List<BodyWeightReading> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(BODY_WEIGHT).path(userprofileId).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String bwReadingsJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<BodyWeightReading>>() {}.getType();
				dtoList = gson.fromJson(bwReadingsJson, type);
				
				log.debug("Bodyweight Readings :" + dtoList.size());
			} else {
				log.error("Error in Find Bodyweight readings");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,	ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find Bodyweight readings:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dtoList;
	}

	public String showDetail() {
		resetMessages();
		selectedBWReading = (BodyWeightReading) bwTable.getRowData();
		setHourMinute(selectedBWReading);
		return "bodyWeight";
	}
	
	public String editDisplay() {
		resetMessages();
		selectedBWReading = (BodyWeightReading) bwTable.getRowData();
		setHourMinute(selectedBWReading);
		return "editBWDisplay";
	}

	public String deleteDisplay() {
		resetMessages();
		selectedBWReading = (BodyWeightReading) bwTable.getRowData();
		setHourMinute(selectedBWReading);
		return "deleteBWDisplay";
	}
	
	private void setHourMinute(BodyWeightReading  selectedBWReading){
		String dateTime =WebUtility.dateToString(selectedBWReading.getReading(),HOUR_MINUTE);
		if(!dateTime.equals(DEFAULT_DATETIME)){
			selectedBWReading.setHour(WebUtility.dateToString(selectedBWReading.getReading(), HOURS));
			selectedBWReading.setMinute(WebUtility.dateToString(selectedBWReading.getReading(), MINUTES));
		}

	}

	public String addDisplay() {
		resetMessages();
		newBWReading=new BodyWeightReading();
		newBWReading.setReading(new Date());
		return "addBWDisplay";
	}
	
	
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newBWReading=new BodyWeightReading();
		newBWReading.setReading(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../bodyweight/addBWDisplay.xhtml");
		return null;
	}

	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String bwid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("bwid");
		if (bwid != null) {
			Long id = Long.valueOf(bwid);
			selectedBWReading=getBWReadingById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../bodyweight/bodyWeight.xhtml");
		return null;
	}

	
	private BodyWeightReading getBWReadingById(Long id) {
		BodyWeightReading dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(BODY_WEIGHT_BY_ID).path(id).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String bwReadingsJson = gson.toJson(response.getPojoObject());
				dto = gson.fromJson(bwReadingsJson, BodyWeightReading.class);
			} else {
				log.error("Error in Find BW reading By id");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find BW reading By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dto;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String bwid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("bwid");
		try{
			if (bwid != null) {
				Long id = Long.valueOf(bwid);
				Gson gson = getGson();
				WebClient client=getWebClient().path(DELETE_BW_READING).path(id).accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete Bodyweight Record" , response.getFailureMessage());
					
					FacesContext.getCurrentInstance().addMessage(null, 
							new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
				}else{
					deleteMessage = true;
					outcome="bodyWeightList";
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete Bodyweight record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		try{
			ResponseUtil response =saveBWReading();
			if(response.isSuccess()){
				outcome="bodyWeightList";
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save Bodyweight record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}

	public ResponseUtil saveBWReading() {
		
		String bwid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("bwid");
		Long id=null;
		BodyWeightReading bwreading=null;
		if (bwid != null) {
			id = Long.valueOf(bwid);
			bwreading=getSelectedBWReading();
		}else{
			bwreading=getNewBWReading();
		}
		Gson gson = getGsonTimeMilli();
		WebClient client= getWebClient().path(BODY_WEIGHT).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		bwreading = prepareBWReading(id,bwreading);
		String bwJson = gson.toJson(bwreading);
		Reader responseReader = new InputStreamReader((InputStream) client.post(bwJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
		if(!response.isSuccess()){
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
		return response;
	}

	private BodyWeightReading prepareBWReading(Long id,BodyWeightReading bwreading) {
		Date dateTime=null;
		if(bwreading.getReading() != null ){
			if(bwreading.getHour() == null  && bwreading.getMinute() == null){
			   dateTime = WebUtility.getDaTeTime(bwreading.getReading(), DEFAULT_HOUR, DEFAULT_MINUTE);
			}else{
			   dateTime = WebUtility.getDaTeTime(bwreading.getReading(), bwreading.getHour(), bwreading.getMinute());	
			}
		}
		bwreading.setReading(dateTime);
		bwreading.setUserprofileId(getUserProfileId());
		return bwreading;
	}

	public String saveAndAdd() {
		String outcome=null;
		try{
			ResponseUtil response=saveBWReading();
			if(response.isSuccess()){
				outcome="addBWDisplay";
				saveAndAddMessage = true;
				newBWReading=new BodyWeightReading();
				newBWReading.setReading(new Date());
			}

		}catch(Exception e){
			log.error("Failed to Save Bodyweight record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}
	
	
	public String updateLineModel(){
        return "bodyWeightGraph";
	}
	
	
	public StreamedContent getJchart(){
		StreamedContent content=null;
		try{
			content =createChart(TITLE,XAXIS,YAXIS);
		}catch(Exception e){
			log.error("Failed to create Chart",e);
		}
		return content;
	}
	
	protected XYDataset createDataset(Set<String> uniqueYears) {
		 TimeSeriesCollection dataset = new TimeSeriesCollection();
		 TimeSeries series1 = new TimeSeries(YAXIS);
		 String period = getPeriod();
		 Date startDate=null;
		 List<BodyWeightReading> graphList;
		 if(!period.equals(PeriodEnumeration.ALL_DATA.getDescription())){
		     startDate =getStartGraphDate(period);
		 }
		 if(startDate != null){
		     graphList = getGraphlist(bwreadings,startDate);
		 }else{
		     graphList = bwreadings;
		 }
	     for( BodyWeightReading bwreading : graphList){
	    	 series1.addOrUpdate(new Day(bwreading.getReading()),bwreading.getBodyweight());
		     uniqueYears.add(CommonUtility.dateToString(bwreading.getReading(),YYYY_MM_DD_HHMMSS_FORMAT).substring(0,4));
	     }
		 dataset.addSeries(series1);
		 return dataset;
	}


	
	private List<BodyWeightReading> getGraphlist(List<BodyWeightReading> bwreadings, Date startDate) {
		List<BodyWeightReading> graphList= new ArrayList<BodyWeightReading>();
		Integer startdateValue = Integer.valueOf(CommonUtility.dateToString(startDate, YYYYMMDD_FORMAT));
		for(BodyWeightReading bwreading : bwreadings){
			Integer readingValue =Integer.valueOf(CommonUtility.dateToString(bwreading.getReading(), YYYYMMDD_FORMAT));
			if(readingValue >= startdateValue){
				graphList.add(bwreading);
			}
		}
		return graphList;
	}


	public List<BodyWeightReading> getBwreadings() {
		return bwreadings;
	}


	public void setBwreadings(List<BodyWeightReading> bwreadings) {
		this.bwreadings = bwreadings;
	}


	public DataTable getBwTable() {
		return bwTable;
	}


	public void setBwTable(DataTable bwTable) {
		this.bwTable = bwTable;
	}


	public BodyWeightReading getSelectedBWReading() {
		return selectedBWReading;
	}


	public void setSelectedBWReading(BodyWeightReading selectedBWReading) {
		this.selectedBWReading = selectedBWReading;
	}


	public BodyWeightReading getNewBWReading() {
		return newBWReading;
	}


	public void setNewBWReading(BodyWeightReading newBWReading) {
		this.newBWReading = newBWReading;
	}

	
}
