package gov.va.med.mhv.vitals.web.controller;

import gov.va.med.mhv.vitals.dto.ResponseUtil;
import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;
import gov.va.med.mhv.vitals.web.form.bean.BodyTemperatureReading;
import gov.va.med.mhv.vitals.web.util.WebUtility;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

@ManagedBean
@Component
@Scope("session")
public class BodyTemperatureController  extends AbstractController {

	private static final long serialVersionUID = -6192092835274409991L;
	private static Logger log = LogManager.getLogger(BodyTemperatureController.class);
	private List<BodyTemperatureReading> tempreadings = new ArrayList<BodyTemperatureReading>();
	private DataTable tempTable;
	private BodyTemperatureReading selectedTempReading = new BodyTemperatureReading();
	private BodyTemperatureReading newTempReading = new BodyTemperatureReading();
	private static final String  TITLE ="Body Temperature";
	private static final String  XAXIS ="Date";
	private static final String  YAXIS ="Degrees(F)";
	private static final String BODY_TEMPERATURE="bodytemperature";
	private static final String DELETE_BT_READING="deleteBodyTemperatureReading";
	private static final String BODY_TEMP_BY_ID="btreadingByid";
	
	
	

	
	
	public void init(ComponentSystemEvent event) {
		findUser();
		Long userprofileId = getUserProfileId();
		if (userprofileId != null) {
			tempreadings = findTempReadings(userprofileId);
		}
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			setPeriod(PeriodEnumeration.ONE_MONTH.getDescription());
		}
	}


	private List<BodyTemperatureReading> findTempReadings(Long userprofileId) {
		List<BodyTemperatureReading> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(BODY_TEMPERATURE).path(userprofileId).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String tempReadingsJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<BodyTemperatureReading>>() {}.getType();
				dtoList = gson.fromJson(tempReadingsJson, type);
				
				log.debug("Temperature Readings :" + dtoList.size());
			} else {
				log.error("Error in Find Temperature  readings");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,	ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find Temperature readings:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,	ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dtoList;
	}

	public String showDetail() {
		resetMessages();
		selectedTempReading = (BodyTemperatureReading) tempTable.getRowData();
		setHourMinute(selectedTempReading);
		return "bodyTemperature";
	}
	
	public String editDisplay() {
		resetMessages();
		selectedTempReading = (BodyTemperatureReading) tempTable.getRowData();
		setHourMinute(selectedTempReading);
		return "editBTDisplay";
	}

	public String deleteDisplay() {
		resetMessages();
		selectedTempReading = (BodyTemperatureReading) tempTable.getRowData();
		setHourMinute(selectedTempReading);
		return "deleteBTDisplay";
	}
	
	private void setHourMinute(BodyTemperatureReading  selectedTempReading){
		String dateTime =WebUtility.dateToString(selectedTempReading.getReading(),HOUR_MINUTE);
		if(!dateTime.equals(DEFAULT_DATETIME)){
			selectedTempReading.setHour(WebUtility.dateToString(selectedTempReading.getReading(), HOURS));
			selectedTempReading.setMinute(WebUtility.dateToString(selectedTempReading.getReading(), MINUTES));
		}

	}

	public String addDisplay() {
		resetMessages();
		newTempReading=new BodyTemperatureReading();
		newTempReading.setReading(new Date());
		return "addBTDisplay";
	}
	
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newTempReading=new BodyTemperatureReading();
		newTempReading.setReading(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../bodytemperature/addBTDisplay.xhtml");
		return null;
	}

	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String btid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("btid");
		if (btid != null) {
			Long id = Long.valueOf(btid);
			selectedTempReading=getBTReadingById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../bodytemperature/bodyTemperature.xhtml");
		return null;
	}

	
	private BodyTemperatureReading getBTReadingById(Long id) {
		BodyTemperatureReading dto=null;
		Reader responseReader =null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(BODY_TEMP_BY_ID).path(id).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String bpReadingsJson = gson.toJson(response.getPojoObject());
				dto = gson.fromJson(bpReadingsJson, BodyTemperatureReading.class);
			} else {
				log.error("Error in Find BT reading By id");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find BT reading By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		
		return dto;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader =null;
		String btid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("btid");
		try{
			if (btid != null) {
				Long id = Long.valueOf(btid);
				Gson gson = getGson();
				WebClient client=getWebClient().path(DELETE_BT_READING).path(id).accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete Tempertaure Record" , response.getFailureMessage());
					
					FacesContext.getCurrentInstance().addMessage(null, 
							new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
				}else{
					deleteMessage = true;
					outcome="bodyTemperatureList";
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete Tempertaure record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		try{
			ResponseUtil response =saveBTReading();
			if(response.isSuccess()){
				outcome="bodyTemperatureList";
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save Tempertaure record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}

	public ResponseUtil saveBTReading() {
		
		String btid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("btid");
		Long id=null;
		BodyTemperatureReading btreading=null;
		if (btid != null) {
			id = Long.valueOf(btid);
			btreading=getSelectedTempReading();
		}else{
			btreading=getNewTempReading();
		}
		Gson gson = getGsonTimeMilli();
		WebClient client= getWebClient().path(BODY_TEMPERATURE).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		btreading = prepareBTReading(id,btreading);
		String btJson = gson.toJson(btreading);
		Reader responseReader = new InputStreamReader((InputStream) client.post(btJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
		if(!response.isSuccess()){
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
		return response;
	}

	private BodyTemperatureReading prepareBTReading(Long id,BodyTemperatureReading btreading) {
		Date dateTime=null;
		if(btreading.getReading() != null ){
			if(btreading.getHour() == null  && btreading.getMinute() == null){
			   dateTime = WebUtility.getDaTeTime(btreading.getReading(), DEFAULT_HOUR, DEFAULT_MINUTE);
			}else{
			   dateTime = WebUtility.getDaTeTime(btreading.getReading(), btreading.getHour(), btreading.getMinute());	
			}
		}
		btreading.setReading(dateTime);
		btreading.setUserprofileId(getUserProfileId());
		return btreading;
	}

	public String saveAndAdd() {
		String outcome=null;
		try{
			ResponseUtil response=saveBTReading();
			if(response.isSuccess()){
				outcome="addBTDisplay";
				saveAndAddMessage = true;
				newTempReading=new BodyTemperatureReading();
				newTempReading.setReading(new Date());
			}

		}catch(Exception e){
			log.error("Failed to Save Temperature record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}
	
	
	public String updateLineModel(){
        return "bodyTemperatureGraph";
	}
	
	
	public StreamedContent getJchart(){
		StreamedContent content=null;
		try{
			content =createChart(TITLE,XAXIS,YAXIS);
		}catch(Exception e){
			log.error("Failed to create Chart",e);
		}
		return content;
	}
	
	
	protected XYDataset createDataset(Set<String> uniqueYears) {
		 TimeSeriesCollection dataset = new TimeSeriesCollection();
		 TimeSeries series1 = new TimeSeries(YAXIS);
		 String period = getPeriod();
		 Date startDate=null;
		 List<BodyTemperatureReading> graphList;
		 if(!period.equals(PeriodEnumeration.ALL_DATA.getDescription())){
		     startDate =getStartGraphDate(period);
		 }
		 if(startDate != null){
		     graphList = getGraphlist(tempreadings,startDate);
		 }else{
		     graphList = tempreadings;
		 }
	     for( BodyTemperatureReading btreading : graphList){
	    	 
	    	 series1.addOrUpdate(new Day(btreading.getReading()),btreading.getBodyTemperature());
		     uniqueYears.add(CommonUtility.dateToString(btreading.getReading(),YYYY_MM_DD_HHMMSS_FORMAT).substring(0,4));
	     }
		 dataset.addSeries(series1);
		 return dataset;
	}


	private List<BodyTemperatureReading> getGraphlist(List<BodyTemperatureReading> btreadings, Date startDate) {
		List<BodyTemperatureReading> graphList= new ArrayList<BodyTemperatureReading>();
		Integer startdateValue = Integer.valueOf(CommonUtility.dateToString(startDate, YYYYMMDD_FORMAT));
		for(BodyTemperatureReading btreading : btreadings){
			Integer readingValue =Integer.valueOf(CommonUtility.dateToString(btreading.getReading(), YYYYMMDD_FORMAT));
			if(readingValue >= startdateValue){
				graphList.add(btreading);
			}
		}
		return graphList;
	}


	public List<BodyTemperatureReading> getTempreadings() {
		return tempreadings;
	}


	public void setTempreadings(List<BodyTemperatureReading> tempreadings) {
		this.tempreadings = tempreadings;
	}


	public DataTable getTempTable() {
		return tempTable;
	}


	public void setTempTable(DataTable tempTable) {
		this.tempTable = tempTable;
	}


	public BodyTemperatureReading getSelectedTempReading() {
		return selectedTempReading;
	}


	public void setSelectedTempReading(BodyTemperatureReading selectedTempReading) {
		this.selectedTempReading = selectedTempReading;
	}


	public BodyTemperatureReading getNewTempReading() {
		return newTempReading;
	}


	public void setNewTempReading(BodyTemperatureReading newTempReading) {
		this.newTempReading = newTempReading;
	}

}
