package gov.va.med.mhv.vitals.web.controller;

import gov.va.med.mhv.vitals.dto.ResponseUtil;
import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;
import gov.va.med.mhv.vitals.web.form.bean.BloodSugarReading;
import gov.va.med.mhv.vitals.web.util.WebUtility;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

@ManagedBean
@Component
@Scope("session")
public class BloodSugarController extends AbstractController {
	
	private static final long serialVersionUID = -2722667818753652061L;
	private static Logger log = LogManager.getLogger(BloodSugarController.class);
	private List<BloodSugarReading> bsreadings = new ArrayList<BloodSugarReading>();
	private DataTable bsTable;
	private BloodSugarReading selectedBSReading = new BloodSugarReading();
	private BloodSugarReading newBSReading = new BloodSugarReading();
	private static final String  TITLE ="Blood Sugar";
	private static final String  XAXIS ="Blood Sugar Count";
	private static final String  YAXIS ="mg/DL";
	private static final String BLOOD_SUGAR="bloodsugar";
	private static final String DELETE_BS_READING="deleteBSReading";
	private static final String BLOOD_SUGAR_BY_ID="bsreadingByid";

	

	public void init(ComponentSystemEvent event) {
		findUser();
		Long userprofileId = getUserProfileId();
		if (userprofileId != null) {
			bsreadings = findBSReadings(userprofileId);
		}
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			setPeriod(PeriodEnumeration.ONE_MONTH.getDescription());
		}
	}


	private List<BloodSugarReading> findBSReadings(Long userprofileId) {
		List<BloodSugarReading> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(BLOOD_SUGAR).path(userprofileId).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String bsReadingsJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<BloodSugarReading>>() {}.getType();
				dtoList = gson.fromJson(bsReadingsJson, type);
				
				log.debug("Blood Sugar Readings :" + dtoList.size());
			} else {
				log.error("Error in Find Blood Sugar readings");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find Blood Sugar readings:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dtoList;
	}

	public String showDetail() {
		resetMessages();
		selectedBSReading = (BloodSugarReading) bsTable.getRowData();
		setHourMinute(selectedBSReading);
		return "bloodSugar";
	}
	
	public String editDisplay() {
		resetMessages();
		selectedBSReading = (BloodSugarReading) bsTable.getRowData();
		setHourMinute(selectedBSReading);
		return "editBSDisplay";
	}

	public String deleteDisplay() {
		resetMessages();
		selectedBSReading = (BloodSugarReading) bsTable.getRowData();
		setHourMinute(selectedBSReading);
		return "deleteBSDisplay";
	}
	
	private void setHourMinute(BloodSugarReading  selectedBSReading){
		String dateTime =WebUtility.dateToString(selectedBSReading.getReading(),HOUR_MINUTE);
		if(!dateTime.equals(DEFAULT_DATETIME)){
			selectedBSReading.setHour(WebUtility.dateToString(selectedBSReading.getReading(), HOURS));
			selectedBSReading.setMinute(WebUtility.dateToString(selectedBSReading.getReading(), MINUTES));
		}

	}

	public String addDisplay() {
		resetMessages();
		newBSReading=new BloodSugarReading();
		newBSReading.setReading(new Date());
		return "addBSDisplay";
	}
	
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newBSReading=new BloodSugarReading();
		newBSReading.setReading(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../bloodsugar/addBSDisplay.xhtml");
		return null;
	}

	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String bsid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("bsid");
		if (bsid != null) {
			Long id = Long.valueOf(bsid);
			selectedBSReading=getBSReadingById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../bloodsugar/bloodSugar.xhtml");
		return null;
	}

	
	private BloodSugarReading getBSReadingById(Long id) {
		BloodSugarReading dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(BLOOD_SUGAR_BY_ID).path(id).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String bpReadingsJson = gson.toJson(response.getPojoObject());
				dto = gson.fromJson(bpReadingsJson, BloodSugarReading.class);
			} else {
				log.error("Error in Find BS reading By id");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find BS reading By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dto;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String bsid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("bsid");
		try{
			if (bsid != null) {
				Long id = Long.valueOf(bsid);
				Gson gson = getGson();
				WebClient client=getWebClient().path(DELETE_BS_READING).path(id).accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete Blood Sugar Record" , response.getFailureMessage());
					
					FacesContext.getCurrentInstance().addMessage(null, 
							new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
				}else{
					deleteMessage = true;
					outcome="bloodSugarList";
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete Blood Sugar record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		try{
			ResponseUtil response =saveBSReading();
			if(response.isSuccess()){
				outcome="bloodSugarList";
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save Blood Sugar record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}

	public ResponseUtil saveBSReading() {
		
		String bsid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("bsid");
		Long id=null;
		BloodSugarReading bsreading=null;
		if (bsid != null) {
			id = Long.valueOf(bsid);
			bsreading=getSelectedBSReading();
		}else{
			bsreading=getNewBSReading();
		}
		Gson gson = getGsonTimeMilli();
		WebClient client= getWebClient().path(BLOOD_SUGAR).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		bsreading = prepareBSReading(id,bsreading);
		String bsJson = gson.toJson(bsreading);
		Reader responseReader = new InputStreamReader((InputStream) client.post(bsJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
		if(!response.isSuccess()){
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
		return response;
	}

	private BloodSugarReading prepareBSReading(Long id,BloodSugarReading bsreading) {
		Date dateTime=null;
		if(bsreading.getReading() != null ){
			if(bsreading.getHour() == null  && bsreading.getMinute() == null){
			   dateTime = WebUtility.getDaTeTime(bsreading.getReading(), DEFAULT_HOUR, DEFAULT_MINUTE);
			}else{
			   dateTime = WebUtility.getDaTeTime(bsreading.getReading(), bsreading.getHour(), bsreading.getMinute());	
			}
		}
		bsreading.setReading(dateTime);
		bsreading.setUserprofileId(getUserProfileId());
		return bsreading;
	}

	public String saveAndAdd() {
		String outcome=null;
		try{
			ResponseUtil response=saveBSReading();
			if(response.isSuccess()){
				outcome="addBSDisplay";
				saveAndAddMessage = true;
				newBSReading=new BloodSugarReading();
				newBSReading.setReading(new Date());
			}

		}catch(Exception e){
			log.error("Failed to Save Blood Sugar record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}
	
	
	public String updateLineModel(){
        return "bloodSugarGraph";
	}
	
	
	public StreamedContent getJchart(){
		StreamedContent content=null;
		try{
			content =createChart(TITLE,XAXIS,YAXIS);
		}catch(Exception e){
			log.error("Failed to create Chart",e);
		}
		return content;
	}
	
	protected XYDataset createDataset(Set<String> uniqueYears) {
		 TimeSeriesCollection dataset = new TimeSeriesCollection();
		 TimeSeries series1 = new TimeSeries(YAXIS);
		 String period = getPeriod();
		 Date startDate=null;
		 List<BloodSugarReading> graphList;
		 if(!period.equals(PeriodEnumeration.ALL_DATA.getDescription())){
		     startDate =getStartGraphDate(period);
		 }
		 if(startDate != null){
		     graphList = getGraphlist(bsreadings,startDate);
		 }else{
		     graphList = bsreadings;
		 }
	     for( BloodSugarReading bsreading : graphList){
	    	 
	    	 series1.addOrUpdate(new Day(bsreading.getReading()),bsreading.getBloodSugarCount());
		     uniqueYears.add(CommonUtility.dateToString(bsreading.getReading(),YYYY_MM_DD_HHMMSS_FORMAT).substring(0,4));
	     }
		 dataset.addSeries(series1);
		 return dataset;
	}

	
	private List<BloodSugarReading> getGraphlist(List<BloodSugarReading> bsreadings, Date startDate) {
		List<BloodSugarReading> graphList= new ArrayList<BloodSugarReading>();
		Integer startdateValue = Integer.valueOf(CommonUtility.dateToString(startDate, YYYYMMDD_FORMAT));
		for(BloodSugarReading bsreading : bsreadings){
			Integer readingValue =Integer.valueOf(CommonUtility.dateToString(bsreading.getReading(), YYYYMMDD_FORMAT));
			if(readingValue >= startdateValue){
				graphList.add(bsreading);
			}
		}
		return graphList;
	}


	public List<BloodSugarReading> getBsreadings() {
		return bsreadings;
	}


	public void setBsreadings(List<BloodSugarReading> bsreadings) {
		this.bsreadings = bsreadings;
	}


	public DataTable getBsTable() {
		return bsTable;
	}


	public void setBsTable(DataTable bsTable) {
		this.bsTable = bsTable;
	}


	public BloodSugarReading getSelectedBSReading() {
		return selectedBSReading;
	}


	public void setSelectedBSReading(BloodSugarReading selectedBSReading) {
		this.selectedBSReading = selectedBSReading;
	}


	public BloodSugarReading getNewBSReading() {
		return newBSReading;
	}


	public void setNewBSReading(BloodSugarReading newBSReading) {
		this.newBSReading = newBSReading;
	}

}
