package gov.va.med.mhv.vitals.web.controller;

import gov.va.med.mhv.vitals.dto.ResponseUtil;
import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;
import gov.va.med.mhv.vitals.web.form.bean.BloodPressureReading;
import gov.va.med.mhv.vitals.web.util.WebUtility;

import java.awt.Color;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.model.StreamedContent;
import org.primefaces.model.chart.AxisType;
import org.primefaces.model.chart.DateAxis;
import org.primefaces.model.chart.LineChartModel;
import org.primefaces.model.chart.LineChartSeries;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

@ManagedBean
@Component
@Scope("session")
public class BloodPressureController extends AbstractController {

	private static final long serialVersionUID = 3674775257581021572L;
	private static Logger log = LogManager.getLogger(BloodPressureController.class);
	private List<BloodPressureReading> bpreadings = new ArrayList<BloodPressureReading>();
	private DataTable bpTable;
	private BloodPressureReading selectedBPReading = new BloodPressureReading();
	private BloodPressureReading newBPReading = new BloodPressureReading();
	private static final String  TITLE ="Blood Pressure";
	private static final String  XAXIS ="Date";
	private static final String  YAXIS ="mmHg";
	private static final String  SERIES1="Systolic";
	private static final String  SERIES2="Diastolic";
	private static final String BLOOD_PRESSURE="bloodpressure";
	private static final String DELETE_BP_READING="deleteBPReading";
	private static final String BLOOD_PRESSURE_BY_ID="bpreadingByid";
	

	public void init(ComponentSystemEvent event) {
		findUser();
		Long userprofileId = getUserProfileId();
		if (userprofileId != null) {
			bpreadings = findBPReadings(userprofileId);
		}
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			setPeriod(PeriodEnumeration.ONE_MONTH.getDescription());
		}
		getJchart();
	}


	private List<BloodPressureReading> findBPReadings(Long userprofileId) {
		List<BloodPressureReading> dtoList = null;
		Reader responseReader=null; 
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(BLOOD_PRESSURE).path(userprofileId).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String bpReadingsJson = gson.toJson(response.getPojoObject());
				Type type = new TypeToken<List<BloodPressureReading>>() {}.getType();
				dtoList = gson.fromJson(bpReadingsJson, type);
				
				log.debug("Bp Readings :" + dtoList.size());
			} else {
				log.error("Error in Find BP readings");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find BP readings:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader = null;
		}
		
		return dtoList;
	}

	public String showDetail() {
		resetMessages();
		selectedBPReading = (BloodPressureReading) bpTable.getRowData();
		setHourMinute(selectedBPReading);
		return "bloodPressure";
	}
	
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String bpid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("bpid");
		if (bpid != null) {
			Long id = Long.valueOf(bpid);
			selectedBPReading=getBPReadingById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../bloodpressure/bloodPressure.xhtml");
		return null;
	}

	
	private BloodPressureReading getBPReadingById(Long id) {
		BloodPressureReading dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(BLOOD_PRESSURE_BY_ID).path(id).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String bpReadingsJson = gson.toJson(response.getPojoObject());
				dto = gson.fromJson(bpReadingsJson, BloodPressureReading.class);
			} else {
				log.error("Error in Find BP reading By id");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find BP reading By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader = null;
		}
		return dto;
	}


	public String editDisplay() {
		resetMessages();
		selectedBPReading = (BloodPressureReading) bpTable.getRowData();
		setHourMinute(selectedBPReading);
		return "editBPDisplay";
	}

	public String deleteDisplay() {
		resetMessages();
		selectedBPReading = (BloodPressureReading) bpTable.getRowData();
		setHourMinute(selectedBPReading);
		return "deleteBPDisplay";
	}
	
	private void setHourMinute(BloodPressureReading  selectedBPReading){
		String dateTime =WebUtility.dateToString(selectedBPReading.getReading(),HOUR_MINUTE);
		if(!dateTime.equals(DEFAULT_DATETIME)){
			selectedBPReading.setHour(WebUtility.dateToString(selectedBPReading.getReading(), HOURS));
			selectedBPReading.setMinute(WebUtility.dateToString(selectedBPReading.getReading(), MINUTES));
		}

	}

	public String addDisplay() {
		resetMessages();
		newBPReading=new BloodPressureReading();
		newBPReading.setReading(new Date());
		return "addBPDisplay";
	}
	
	
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newBPReading=new BloodPressureReading();
		newBPReading.setReading(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../bloodpressure/addBPDisplay.xhtml");
		return null;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String bpid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("bpid");
		try{
			if (bpid != null) {
				Long id = Long.valueOf(bpid);
				Gson gson = getGson();
				WebClient client=getWebClient().path(DELETE_BP_READING).path(id).accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
				if (!response.isSuccess()) {
					log.debug("Failed to Delete BP Record" , response.getFailureMessage());
					
					FacesContext.getCurrentInstance().addMessage(null, 
							new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
				}else{
					deleteMessage = true;
					outcome="bloodPressureList";
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete BP record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		try{
			ResponseUtil response =saveBPReading();
			if(response.isSuccess()){
				outcome="bloodPressureList";
				saveMessage = true;
			}
		}catch(Exception e){
			log.error("Failed to Save BP record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}

	public ResponseUtil saveBPReading() {
		
		String bpid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("bpid");
		Long id=null;
		BloodPressureReading bpreading=null;
		if (bpid != null) {
			id = Long.valueOf(bpid);
			bpreading=getSelectedBPReading();
		}else{
			bpreading=getNewBPReading();
		}
		Gson gson = getGsonTimeMilli();
		WebClient client= getWebClient().path(BLOOD_PRESSURE).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		bpreading = prepareBPReading(id,bpreading);
		String bpJson = gson.toJson(bpreading);
		Reader responseReader = new InputStreamReader((InputStream) client.post(bpJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
		if(!response.isSuccess()){
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
		return response;
	}

	private BloodPressureReading prepareBPReading(Long id,BloodPressureReading bpreading) {
		Date dateTime=null;
		if(bpreading.getReading() != null ){
			if(bpreading.getHour() == null  && bpreading.getMinute() == null){
			   dateTime = WebUtility.getDaTeTime(bpreading.getReading(), DEFAULT_HOUR, DEFAULT_MINUTE);
			}else{
			   dateTime = WebUtility.getDaTeTime(bpreading.getReading(), bpreading.getHour(), bpreading.getMinute());	
			}
		}
		bpreading.setReading(dateTime);
		bpreading.setUserprofileId(getUserProfileId());
		return bpreading;
	}

	public String saveAndAdd() {
		String outcome=null;
		try{
			ResponseUtil response=saveBPReading();
			if(response.isSuccess()){
				outcome="addBPDisplay";
				saveAndAddMessage = true;
				newBPReading=new BloodPressureReading();
				newBPReading.setReading(new Date());
			}

		}catch(Exception e){
			log.error("Failed to Save BP record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}
	
	public String updateLineModel(){
        return "bloodPressureGraph";
	}
	
	
	public LineChartModel   getLineModel(){
		LineChartModel dateModel = new LineChartModel();
	    LineChartSeries series1 = new LineChartSeries();
	    LineChartSeries series2 = new LineChartSeries();
	    Set<String> uniqueYears = new HashSet<String>();
	    String period = getPeriod();
	    Date startDate=null;
	    List<BloodPressureReading> graphList;
	    if(!period.equals(PeriodEnumeration.ALL_DATA.getDescription())){
	    	startDate =getStartGraphDate(period);
	    }
	    if(startDate != null){
	       graphList = getGraphlist(bpreadings,startDate);
	    }else{
	       graphList = bpreadings;
	    }
	    for( BloodPressureReading bpreading : graphList){
	    	series1.set(CommonUtility.dateToString(bpreading.getReading(),YYYY_MM_DD_HHMMSS_FORMAT), bpreading.getDiastolic());
	    	uniqueYears.add(CommonUtility.dateToString(bpreading.getReading(),YYYY_MM_DD_HHMMSS_FORMAT).substring(0,4));
	    }
	    for( BloodPressureReading bpreading : graphList){
	    	series2.set(CommonUtility.dateToString(bpreading.getReading(),YYYY_MM_DD_HHMMSS_FORMAT), bpreading.getSystolic());
	    }
	    dateModel.addSeries(series1);
	    dateModel.addSeries(series2);
		dateModel.getAxis(AxisType.Y).setLabel("BPM");
		DateAxis axis = new DateAxis("DATE");
		axis.setTickAngle(-90);
		setTickValues(axis,period,uniqueYears);
		dateModel.getAxes().put(AxisType.X, axis);  
		dateModel.setExtender("chartExtender");
        return dateModel;
	}
	
	
	public StreamedContent getJchart(){
		StreamedContent content=null;
		try{
			content =createChart(TITLE,XAXIS,YAXIS);
		}catch(Exception e){
			log.error("Failed to create Chart",e);
		}
		return content;
	}
	
	
	protected void setValueRanges(XYPlot plot) {
		Marker diastHigh= new ValueMarker(80);
		Marker diastHyp= new ValueMarker(90);
		Marker systHigh= new ValueMarker(120);
		diastHigh.setPaint(Color.black);
		diastHyp.setPaint(Color.black);
		systHigh.setPaint(Color.black);
		diastHigh.setLabel("Diast High");
		diastHyp.setLabel("Diast Hyp");
		systHigh.setLabel("Syst High");
		diastHigh.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
		diastHyp.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
		systHigh.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
		diastHigh.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
		diastHyp.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
		systHigh.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
		plot.addRangeMarker(diastHigh);
		plot.addRangeMarker(diastHyp);
		plot.addRangeMarker(systHigh);
	}


	
	protected XYDataset createDataset(Set<String> uniqueYears) {
		 TimeSeriesCollection dataset = new TimeSeriesCollection();
		 TimeSeries series1 = new TimeSeries(SERIES1);
		 TimeSeries series2 = new TimeSeries(SERIES2);
		 String period = getPeriod();
		 Date startDate=null;
		 List<BloodPressureReading> graphList;
		 if(!period.equals(PeriodEnumeration.ALL_DATA.getDescription())){
		     startDate =getStartGraphDate(period);
		 }
		 if(startDate != null){
		     graphList = getGraphlist(bpreadings,startDate);
		 }else{
		     graphList = bpreadings;
		 }
	     for( BloodPressureReading bpreading : graphList){
	    	 
	    	 series2.addOrUpdate(new Day(bpreading.getReading()),bpreading.getDiastolic());
	    	 series1.addOrUpdate(new Day(bpreading.getReading()),bpreading.getSystolic());
		     uniqueYears.add(CommonUtility.dateToString(bpreading.getReading(),YYYY_MM_DD_HHMMSS_FORMAT).substring(0,4));
		     
	     }
		 dataset.addSeries(series1);
		 dataset.addSeries(series2);
		 return dataset;
	}

	


	private List<BloodPressureReading> getGraphlist(List<BloodPressureReading> bpeadings, Date startDate) {
		List<BloodPressureReading> graphList= new ArrayList<BloodPressureReading>();
		Integer startdateValue = Integer.valueOf(CommonUtility.dateToString(startDate, YYYYMMDD_FORMAT));
		for(BloodPressureReading bpreading : bpeadings){
			Integer readingValue =Integer.valueOf(CommonUtility.dateToString(bpreading.getReading(), YYYYMMDD_FORMAT));
			if(readingValue >= startdateValue){
				graphList.add(bpreading);
			}
		}
		return graphList;
	}


	public List<BloodPressureReading> getBpreadings() {
		return bpreadings;
	}

	public void setBpreadings(List<BloodPressureReading> bpreadings) {
		this.bpreadings = bpreadings;
	}

	public DataTable getBpTable() {
		return bpTable;
	}

	public void setBpTable(DataTable bpTable) {
		this.bpTable = bpTable;
	}

	public BloodPressureReading getSelectedBPReading() {
		return selectedBPReading;
	}

	public void setSelectedBPReading(BloodPressureReading selectedBPReading) {
		this.selectedBPReading = selectedBPReading;
	}

	public BloodPressureReading getNewBPReading() {
		return newBPReading;
	}

	public void setNewBPReading(BloodPressureReading newBPReading) {
		this.newBPReading = newBPReading;
	}

}
