package gov.va.med.mhv.vitals.web.validator;

import java.math.BigDecimal;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="LpidisTriglycerValidator")
public class LpidisTriglycerValidator implements Validator{
	
	private static final BigDecimal TRIGLYCERIDES_MIN_VALUE = new BigDecimal("10.0");
	private static final BigDecimal TRIGLYCERIDES_MAX_VALUE = new BigDecimal("2000.0");

	@Override
	public void validate(FacesContext context, UIComponent component,Object value) throws ValidatorException {
		
		BigDecimal triglycer=(BigDecimal)value;
		
		if(triglycer.compareTo(TRIGLYCERIDES_MAX_VALUE) > 0){
			String summary = "The Triglycerides value must be less than or equal to 2,000.";
			String detail = "Enter a value less than or equal to 2,000.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}else  if(triglycer.compareTo(TRIGLYCERIDES_MIN_VALUE) < 0){
			String summary = "The Triglycerides value must be greater than or equal to 10.";
			String detail = "Enter a value greater than or equal to 10.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}
	}

}
