package gov.va.med.mhv.vitals.web.validator;

import java.math.BigDecimal;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="LpidisHdlValidator")
public class LpidisHdlValidator implements Validator {
	
	private static final BigDecimal HDL_MIN_VALUE = new BigDecimal("6.0");
	private static final BigDecimal HDL_MAX_VALUE = new BigDecimal("600.0");

	@Override
	public void validate(FacesContext context, UIComponent component,Object value) throws ValidatorException {
		
		BigDecimal lipidsHdl=(BigDecimal)value;
		
		if(lipidsHdl.compareTo(HDL_MAX_VALUE) > 0){
			String summary = "The HDL value must be less than or equal to 600.";
			String detail = "Enter a value less than or equal to 600.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}else  if(lipidsHdl.compareTo(HDL_MIN_VALUE) < 0){
			String summary = "The HDL value must be greater than or equal to 6.";
			String detail = "Enter a value greater than or equal to 6.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}
	}

}
