package gov.va.med.mhv.vitals.web.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="DiastolicValidator")
public class DiastolicValidator implements Validator{

	@Override
	public void validate(FacesContext context, UIComponent component,
			Object value) throws ValidatorException {
		
		Integer systValue =null;
		Integer diastValue=null;
		if(value != null){
			diastValue =(Integer)value;
		}
		
		UIInput systInput= (UIInput)component.getAttributes().get("syst");
		
		 Object obj =systInput.getSubmittedValue();
		 try{
			 if(obj != null){
				 systValue = Integer.valueOf((String) obj);
			 }
		 }catch(Exception e){
			 
		 }
		 
		 if(systValue != null &&diastValue != null && systValue <= diastValue){
				String summary = "The diastolic value must be less than the systolic value.";
				String detail = "The diastolic value must be less than the systolic value.";
	
				throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		 }		
	
	}

}
