package gov.va.med.mhv.vitals.web.validator;

import java.math.BigDecimal;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="BodyWeightValidator")
public class BodyWeightValidator implements Validator{
	private static final BigDecimal BODYWEIGHT_MIN_VALUE = new BigDecimal("10");
	private static final BigDecimal BODYWEIGHT_MAX_VALUE = new BigDecimal("999.99");

	@Override
	public void validate(FacesContext context, UIComponent component,
			Object value) throws ValidatorException {
		
		BigDecimal bodyWeight=(BigDecimal)value;
		
		if(bodyWeight.compareTo(BODYWEIGHT_MAX_VALUE) > 0){
			String summary = "The Body Weight value must be less than or equal to 999.99.";
			String detail = "Enter a value less than or equal to 999.99.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}else  if(bodyWeight.compareTo(BODYWEIGHT_MIN_VALUE) < 0){
			String summary = "The Body Weight value must be greater than or equal to 10.";
			String detail = "Enter a value greater than or equal to 10.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}
	}
}
