package gov.va.med.mhv.vitals.web.util;

import java.io.Serializable;
import java.util.regex.Pattern;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;

import org.springframework.stereotype.Component;

@ManagedBean
@Component

public class WebValidator implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -390029229129088245L;
	private static final String NAME_PATTERN = "^[A-Za-z]+$";
	private static final String EMAIL_PATTERN ="^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
	
	
	public WebValidator(){
		
	}
	
	public void validateNumber(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		String inputValue =(String)value;
		try{
			Integer.parseInt(inputValue);
		}catch(Exception e){
			String msg= "'"+inputValue+"'"+ "is not a valid number";
			 FacesContext.getCurrentInstance().addMessage(null,
   				  new FacesMessage(FacesMessage.SEVERITY_ERROR,msg,msg));
   		
			//throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
		}
	}
	
	public void validateComments(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		String inputValue =(String)value;
		
			String msg= "'"+inputValue+"'"+ "is not a valid number";
			// FacesContext.getCurrentInstance().addMessage(null,
   			//	  new FacesMessage(FacesMessage.SEVERITY_ERROR,msg,msg));
   		
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
		
	}



	public void validateName(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		validateRegExpression(context,component,value,NAME_PATTERN);
	}
	
	public void validateEmail(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		validateRegExpression(context,component,value,EMAIL_PATTERN);
	}
	
	private void validateRegExpression(FacesContext context, UIComponent component, Object value,String regex){
		String inputValue =(String)value;
		Pattern pattern= Pattern.compile(regex);
		if(!pattern.matcher(inputValue).matches()){
			String controlName=(String)component.getAttributes().get("title");
			String msg= controlName + " is invalid";
			
			//TODO : Remove this commented block after testing  get rid of duplicate error messages
			// FacesContext.getCurrentInstance().addMessage(null,
   			//	  new FacesMessage(FacesMessage.SEVERITY_ERROR,msg,msg));
   		
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
		}
	}
}
