package gov.va.med.mhv.vitals.web.controller;

import java.util.ArrayList;
import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.vitals.dto.BloodPressureReadingDTO;
import gov.va.med.mhv.vitals.dto.BloodSugarReadingDTO;
import gov.va.med.mhv.vitals.dto.BodyTemperatureDTO;
import gov.va.med.mhv.vitals.dto.BodyWeightReadingDTO;
import gov.va.med.mhv.vitals.dto.HeartRateReadingDTO;
import gov.va.med.mhv.vitals.dto.InrReadingDTO;
import gov.va.med.mhv.vitals.dto.LipidsReadingDTO;
import gov.va.med.mhv.vitals.dto.PainReadingDTO;
import gov.va.med.mhv.vitals.dto.PulseOximetryReadingDTO;
import gov.va.med.mhv.vitals.dto.VitalSignsSummaryDTO;

@ManagedBean
@Component
@SessionScoped
public class VitalsController  extends AbstractController{
	private static final long serialVersionUID = -4834598324705181876L;
	private static Logger log = LogManager.getLogger(VitalsController.class);
	private List<BloodPressureReadingDTO> bpreadings = new ArrayList<BloodPressureReadingDTO>();
	private List<BloodSugarReadingDTO> bsreadings = new ArrayList<BloodSugarReadingDTO>();
	private List<BodyTemperatureDTO> tempreadings = new ArrayList<BodyTemperatureDTO>();
	private List<BodyWeightReadingDTO> bwreadings = new ArrayList<BodyWeightReadingDTO>();
	private List<HeartRateReadingDTO> hrreadings = new ArrayList<HeartRateReadingDTO>();
	private List<InrReadingDTO> inrreadings = new ArrayList<InrReadingDTO>();
	private List<LipidsReadingDTO> lpreadings = new ArrayList<LipidsReadingDTO>();
	private List<PainReadingDTO> painReadings = new ArrayList<PainReadingDTO>();
	private List<PulseOximetryReadingDTO> poreadings = new ArrayList<PulseOximetryReadingDTO>();
	
	
	public void init(ComponentSystemEvent event) {
		findUser();
		Long userprofileId = getUserProfileId();
		try{
		   if (userprofileId != null) {
			   
			   VitalSignsSummaryDTO summary = this.vitalSignsService.getVitalSignsSummary(userprofileId);
			   
			   bpreadings = summary.getBloodPreassureReadings();
			   bsreadings=summary.getBloodSugarReadings();
			   tempreadings=summary.getBodyTemperatureReadings();
			   bwreadings=summary.getBodyWeightReadings();
			   hrreadings=summary.getHeartRateReadings();
			   inrreadings=summary.getInrReadings();
			   lpreadings=summary.getLipidReadings();
			   painReadings=summary.getPainReadings();
			   poreadings=summary.getPulseOximetryReadings();
			}
		}catch (Exception e){
			log.error(e);
			
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}
	}
	

	public List<BloodPressureReadingDTO> getBpreadings() {
		return bpreadings;
	}


	public void setBpreadings(List<BloodPressureReadingDTO> bpreadings) {
		this.bpreadings = bpreadings;
	}


	public List<BloodSugarReadingDTO> getBsreadings() {
		return bsreadings;
	}


	public void setBsreadings(List<BloodSugarReadingDTO> bsreadings) {
		this.bsreadings = bsreadings;
	}


	public List<BodyTemperatureDTO> getTempreadings() {
		return tempreadings;
	}


	public void setTempreadings(List<BodyTemperatureDTO> tempreadings) {
		this.tempreadings = tempreadings;
	}


	public List<BodyWeightReadingDTO> getBwreadings() {
		return bwreadings;
	}


	public void setBwreadings(List<BodyWeightReadingDTO> bwreadings) {
		this.bwreadings = bwreadings;
	}


	public List<HeartRateReadingDTO> getHrreadings() {
		return hrreadings;
	}


	public void setHrreadings(List<HeartRateReadingDTO> hrreadings) {
		this.hrreadings = hrreadings;
	}


	public List<InrReadingDTO> getInrreadings() {
		return inrreadings;
	}


	public void setInrreadings(List<InrReadingDTO> inrreadings) {
		this.inrreadings = inrreadings;
	}


	public List<LipidsReadingDTO> getLpreadings() {
		return lpreadings;
	}


	public void setLpreadings(List<LipidsReadingDTO> lpreadings) {
		this.lpreadings = lpreadings;
	}


	public List<PainReadingDTO> getPainReadings() {
		return painReadings;
	}


	public void setPainReadings(List<PainReadingDTO> painReadings) {
		this.painReadings = painReadings;
	}


	public List<PulseOximetryReadingDTO> getPoreadings() {
		return poreadings;
	}


	public void setPoreadings(List<PulseOximetryReadingDTO> poreadings) {
		this.poreadings = poreadings;
	}
}
