package gov.va.med.mhv.vitals.web.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.vitals.dto.PainReadingDTO;
import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;
import gov.va.med.mhv.vitals.web.util.WebUtility;

@ManagedBean
@Component
@Scope("session")
public class PainController extends AbstractController {

	private static final long serialVersionUID = 5666598826183015313L;

	private static Logger log = LogManager.getLogger(PainController.class);
	private List<PainReadingDTO> painReadings = new ArrayList<PainReadingDTO>();
	private DataTable painTable;
	private PainReadingDTO selectedPainReading = new PainReadingDTO();
	private PainReadingDTO newPainreading = new PainReadingDTO();
	private static final String TITLE = "Pain";
	private static final String XAXIS = "Date";
	private static final String YAXIS = "Pain Level";
	private String addPain ;
	private String editPain;

	public void init(ComponentSystemEvent event) {
		findUser();
		userprofileId = getUserProfileId();
		painTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("painForm:painData");
		if (!FacesContext.getCurrentInstance().isPostback()) {
			resetMessages();
			if (userprofileId != null) {
				painReadings = findPainReadings(userprofileId);
			}
			setRowsPerPage(10);
			setPeriod(PeriodEnumeration.ONE_MONTH.getDescription());
		}
		else{
			if(sortColumn != null && sortBy != null){
				painTable.setValueExpression("sortBy", sortColumn);
				painTable.setSortOrder(sortBy);
			} 
		}
	}
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}

	private List<PainReadingDTO> findPainReadings(Long userprofileId) {
		List<PainReadingDTO> dtoList = null;

		try {

			dtoList = this.vitalSignsService.getPainReadingsForUser(userprofileId);

		} catch (Exception e) {
			log.error("Error in Find Pain readings:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return dtoList;
	}

	public String showDetail(PainReadingDTO painReadingDTO) {
		resetMessages();
		selectedPainReading = painReadingDTO;
		setHourMinute(selectedPainReading);
		return "pain";
	}
	
	public String editDisplay(PainReadingDTO painReadingDTO) {
		resetMessages();
		selectedPainReading = painReadingDTO;
		setEditPain(String.valueOf(selectedPainReading.getPainLevel()));
		setHourMinute(selectedPainReading);
		return "editPainDisplay";
	}
	
	public String resetEditDisplay(){
		return "editPainDisplay";
	}


	public String deleteDisplay(PainReadingDTO painReadingDTO) {
		resetMessages();
		selectedPainReading = painReadingDTO;
		setHourMinute(selectedPainReading);
		setDeleteOrigin("tableView");
		return "deletePainDisplay";
	}

	public String deleteRecordDisplay() {
		resetMessages();
		setDeleteOrigin(null);
		return "deletePainDisplay";
	}

	private void setHourMinute(PainReadingDTO selectedPainReading) {
		String dateTime = WebUtility.dateToString(selectedPainReading.getReading(), HOUR_MINUTE);
		if (!dateTime.equals(DEFAULT_DATETIME)) {
			selectedPainReading.setHour(WebUtility.dateToString(selectedPainReading.getReading(), HOURS));
			selectedPainReading.setMinute(WebUtility.dateToString(selectedPainReading.getReading(), MINUTES));
		}

	}

	public String addDisplay() {
		resetMessages();
		newPainreading = new PainReadingDTO();
		newPainreading.setReading(new Date());
		return "addPainDisplay";
	}

	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		if (userprofileId != null) {
			painReadings = findPainReadings(userprofileId);
		}
		newPainreading = new PainReadingDTO();
		newPainreading.setReading(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().handleNavigation(context, null,
				"/views/pain/addPainDisplay.xhtml");
		return null;
	}
	
	public String dashboardViewMore() {
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		if (userprofileId != null) {
			painReadings = findPainReadings(userprofileId);
		}
		return "/views/pain/painList";
	}

	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String painid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("painid");
		Long userProfileId = getUserProfileId();
		if (painid != null && userProfileId != null) {
			Long id = Long.valueOf(painid);
			selectedPainReading = getPaindReadingById(userProfileId, id);
		}
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().handleNavigation(context, null, "/views/pain/pain.xhtml");
		return null;
	}

	private PainReadingDTO getPaindReadingById(Long userProfileId, Long id) {
		PainReadingDTO dto = null;
		try {

			dto = this.vitalSignsService.getPainReadingByid(userProfileId, id);

		} catch (Exception e) {
			log.error("Error in Find Pain reading By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return dto;
	}

	public String delete() {
		String outcome = null;
		String painid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("painid");
		Long userProfileId = getUserProfileId();
		try {
			if (painid != null && userProfileId != null) {
				Long id = Long.valueOf(painid);

				this.vitalSignsService.deletePainReading(userProfileId, id);
				painReadings = findPainReadings(userprofileId);
				deleteMessage = true;
				outcome = "painList";
			}
		} catch (Exception e) {
			log.error("Failed to Delete Pain record", e);

			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return outcome;
	}

	public String save() {
		String outcome = null;
		try {
			if (savePainReading().getPainId() != null) {
				outcome = "painList";
				painReadings = findPainReadings(userprofileId);
				saveMessage = true;
			}
		} catch (MHVException e) {
			log.error("Failed to Save Pain record", e);

			if (e.getValidationErrorMessages() != null) {
				addValidationMessages(e.getValidationErrorMessages());
			} else {
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}
		}
		return outcome;
	}

	public PainReadingDTO savePainReading() throws MHVException {
		resetMessages();
		String painid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("painid");
		Long id = null;
		PainReadingDTO painReading = null;
		if (painid != null) {
			id = Long.valueOf(painid);
			painReading = getSelectedPainReading();
			if(editPain != null && !editPain.isEmpty()){
				painReading.setPainLevel(Integer.valueOf(editPain));
			}
		} else {
			painReading = getNewPainreading();
			if(addPain != null && !addPain.isEmpty()){
				painReading.setPainLevel(Integer.valueOf(addPain));
			}
		}

		painReading = preparePainReading(id, painReading);
		Long prId = this.vitalSignsService.savePainReading(painReading);
		painReading.setPainId(prId);
		editPain=null;
		addPain=null;
		return painReading;

	}

	private PainReadingDTO preparePainReading(Long id, PainReadingDTO painReading) {
		Date dateTime = null;
		if (painReading.getReading() != null) {
			if (painReading.getHour() == null && painReading.getMinute() == null) {
				dateTime = WebUtility.getDaTeTime(painReading.getReading(), DEFAULT_HOUR, DEFAULT_MINUTE);
			} else {
				dateTime = WebUtility.getDaTeTime(painReading.getReading(), painReading.getHour(),
						painReading.getMinute());
			}
		}
		painReading.setReading(dateTime);
		painReading.setUserprofileId(getUserProfileId());
		return painReading;
	}

	public String saveAndAdd() {
		String outcome = null;
		try {
			if (savePainReading().getPainId() != null) {
				outcome = "addPainDisplay";
				saveAndAddMessage = true;
				newPainreading = new PainReadingDTO();
				newPainreading.setReading(new Date());
				painReadings = findPainReadings(userprofileId);
			}

		} catch (MHVException e) {
			log.error("Failed to Save Pain record", e);

			if (e.getValidationErrorMessages() != null) {
				addValidationMessages(e.getValidationErrorMessages());
			} else {
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}
		}
		return outcome;
	}

	public String updateLineModel() {
		return "painGraph";
	}

	public StreamedContent getJchart() {
		StreamedContent content = null;
		try {
			content = createChart(TITLE, XAXIS, YAXIS);
		} catch (Exception e) {
			log.error("Failed to create Chart", e);
		}
		return content;
	}

	protected XYDataset createDataset(Set<String> uniqueYears) {
		TimeSeriesCollection dataset = new TimeSeriesCollection();
		TimeSeries series1 = new TimeSeries(YAXIS);
		String period = getPeriod();
		Date startDate = null;
		List<PainReadingDTO> graphList;
		if (!period.equals(PeriodEnumeration.ALL_DATA.getDescription())) {
			startDate = getStartGraphDate(period);
		}
		if (startDate != null) {
			graphList = getGraphlist(painReadings, startDate);
		} else {
			graphList = painReadings;
		}
		for (PainReadingDTO reading : graphList) {
			series1.addOrUpdate(new Day(reading.getReading()), reading.getPainLevel());
			uniqueYears.add(CommonUtility.dateToString(reading.getReading(), YYYY_MM_DD_HHMMSS_FORMAT).substring(0, 4));
		}
		dataset.addSeries(series1);
		return dataset;
	}

	private List<PainReadingDTO> getGraphlist(List<PainReadingDTO> painReadings, Date startDate) {
		List<PainReadingDTO> graphList = new ArrayList<PainReadingDTO>();
		Integer startdateValue = Integer.valueOf(CommonUtility.dateToString(startDate, YYYYMMDD_FORMAT));
		for (PainReadingDTO painReading : painReadings) {
			Integer readingValue = Integer
					.valueOf(CommonUtility.dateToString(painReading.getReading(), YYYYMMDD_FORMAT));
			if (readingValue >= startdateValue) {
				graphList.add(painReading);
			}
		}
		return graphList;
	}

	public String printerFriendlySummary(){
		resetMessages();
		painTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("painForm:painData");
		return "printPainSummary";
	}

	public List<PainReadingDTO> getPainReadings() {
		return painReadings;
	}

	public void setPainReadings(List<PainReadingDTO> painReadings) {
		this.painReadings = painReadings;
	}

	public DataTable getPainTable() {
		return painTable;
	}

	public void setPainTable(DataTable painTable) {
		this.painTable = painTable;
	}

	public PainReadingDTO getSelectedPainReading() {
		return selectedPainReading;
	}

	public void setSelectedPainReading(PainReadingDTO selectedPainReading) {
		this.selectedPainReading = selectedPainReading;
	}

	public PainReadingDTO getNewPainreading() {
		return newPainreading;
	}

	public void setNewPainreading(PainReadingDTO newPainreading) {
		this.newPainreading = newPainreading;
	}

	public String getAddPain() {
		return addPain;
	}

	public void setAddPain(String addPain) {
		this.addPain = addPain;
	}

	public String getEditPain() {
		return editPain;
	}

	public void setEditPain(String editPain) {
		this.editPain = editPain;
	}

}
