package gov.va.med.mhv.vitals.web.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.primefaces.model.StreamedContent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.vitals.dto.HeartRateReadingDTO;
import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;
import gov.va.med.mhv.vitals.web.util.WebUtility;

@ManagedBean
@Component
@Scope("session")
public class HeartRateController extends AbstractController {

	private static final long serialVersionUID = 1589077815230808123L;
	private static Logger log = LogManager.getLogger(HeartRateController.class);
	private List<HeartRateReadingDTO> hrreadings = new ArrayList<HeartRateReadingDTO>();
	private DataTable hrTable;
	private HeartRateReadingDTO selectedHRReading = new HeartRateReadingDTO();
	private HeartRateReadingDTO newHRReading = new HeartRateReadingDTO();
	private static final String TITLE = "Heart Rate";
	private static final String XAXIS = "Date";
	private static final String YAXIS = "BPM";
	private static final String SERIES1 = "Heart Rate";

	public void init(ComponentSystemEvent event) {
		findUser();
		userprofileId = getUserProfileId();
		hrTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("heartrateForm:hrlist");
		if (!FacesContext.getCurrentInstance().isPostback()) {
			resetMessages();
			if (userprofileId != null) {
				hrreadings = findHRReadings(userprofileId);
			}
			setRowsPerPage(10);
			setPeriod(PeriodEnumeration.ONE_MONTH.getDescription());
		}
		else{
			if(sortColumn != null && sortBy != null){
				hrTable.setValueExpression("sortBy", sortColumn);
				hrTable.setSortOrder(sortBy);
			} 
		}
	}
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}

	private List<HeartRateReadingDTO> findHRReadings(Long userprofileId) {
		List<HeartRateReadingDTO> dtoList = null;
		try {

			dtoList = this.vitalSignsService.getHeartRateReadingsForUser(userprofileId);

		} catch (Exception e) {
			log.error("Error in Find Heartrate readings:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return dtoList;
	}

	public String showDetail(HeartRateReadingDTO hrReading) {
		resetMessages();
		selectedHRReading = hrReading;
		setHourMinute(selectedHRReading);
		return "heartRate";
	}

	public String editDisplay(HeartRateReadingDTO hrReading) {
		resetMessages();
		selectedHRReading = hrReading;
		setHourMinute(selectedHRReading);
		return "editHRDisplay";
	}
	
	public String resetEditDisplay(){
		return "editHRDisplay";
	}

	public String deleteDisplay(HeartRateReadingDTO hrReading) {
		resetMessages();
		selectedHRReading = hrReading;
		setHourMinute(selectedHRReading);
		setDeleteOrigin("tableView");
		return "deleteHRDisplay";
	}
	
	public String deleteRecordDisplay() {
		resetMessages();
		setDeleteOrigin(null);
		return "deleteHRDisplay";
	}


	private void setHourMinute(HeartRateReadingDTO  selectedHRReading){
		String dateTime =WebUtility.dateToString(selectedHRReading.getReading(),HOUR_MINUTE);
		if(!dateTime.equals(DEFAULT_DATETIME)){
			selectedHRReading.setHour(WebUtility.dateToString(selectedHRReading.getReading(), HOURS));
			selectedHRReading.setMinute(WebUtility.dateToString(selectedHRReading.getReading(), MINUTES));
		}

	}

	public String addDisplay() {
		resetMessages();
		newHRReading = new HeartRateReadingDTO();
		newHRReading.setReading(new Date());
		return "addHRDisplay";
	}

	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		if (userprofileId != null) {
			hrreadings = findHRReadings(userprofileId);
		}
		newHRReading = new HeartRateReadingDTO();
		newHRReading.setReading(new Date());
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().handleNavigation(context, null,
				"/views/heartrate/addHRDisplay.xhtml");
		return null;
	}
	
	public String dashboardViewMore() {
		resetMessages();
		findUser();
		setRowsPerPage(10);
		userprofileId = getUserProfileId();
		if (userprofileId != null) {
			hrreadings = findHRReadings(userprofileId);
		}
		return "/views/heartrate/heartRateList";
	}
	
	public String printerFriendlySummary(){
		resetMessages();
		hrTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("heartrateForm:hrlist");
		return "printHRSummary";
	}

	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String hrid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("hrid");
		Long userProfileId = getUserProfileId();
		if (hrid != null && userProfileId != null) {
			Long id = Long.valueOf(hrid);
			selectedHRReading = getHRReadingById(userProfileId, id);
		}
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().handleNavigation(context, null,
				"/views/heartrate/heartRate.xhtml");
		return null;
	}

	private HeartRateReadingDTO getHRReadingById(Long userProfileId, Long id) {
		HeartRateReadingDTO dto = null;
		try {

			dto = this.vitalSignsService.getHeartRateReadingByid(userProfileId, id);

		} catch (Exception e) {
			log.error("Error in Find HR reading By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return dto;
	}

	public String delete() {
		String outcome = null;
		String hrid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("hrid");
		Long userProfileId = getUserProfileId();

		try {
			if (hrid != null) {
				Long id = Long.valueOf(hrid);

				this.vitalSignsService.deleteHeartRateReading(userProfileId, id);
				hrreadings = findHRReadings(userprofileId);
				deleteMessage = true;
				outcome = "heartRateList";
			}
		} catch (Exception e) {
			log.error("Failed to Delete HeartRate record", e);

			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}

		return outcome;
	}

	public String save() {
		String outcome = null;
		try {
			if (saveHRReading().getHeartRateId() != null) {
				outcome = "heartRateList";
				hrreadings = findHRReadings(userprofileId);
				saveMessage = true;
			}
		} catch (MHVException e) {

			log.error("Failed to Save HeartRate record", e);

			if (e.getValidationErrorMessages() != null) {
				addValidationMessages(e.getValidationErrorMessages());
			} else {
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}
		}
		return outcome;
	}

	public HeartRateReadingDTO saveHRReading() throws MHVException {
		resetMessages();
		String hrid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("hrid");
		Long id = null;
		HeartRateReadingDTO hrreading = null;
		if (hrid != null) {
			id = Long.valueOf(hrid);
			hrreading = getSelectedHRReading();
		} else {
			hrreading = getNewHRReading();
		}

		hrreading = prepareHRReading(id, hrreading);
		Long hrrId = this.vitalSignsService.saveHeartRateReading(hrreading);
		hrreading.setHeartRateId(hrrId);
		return hrreading;
	}

	private HeartRateReadingDTO prepareHRReading(Long id, HeartRateReadingDTO hrreading) {
		Date dateTime = null;
		if (hrreading.getReading() != null) {
			if (hrreading.getHour() == null && hrreading.getMinute() == null) {
				dateTime = WebUtility.getDaTeTime(hrreading.getReading(), DEFAULT_HOUR, DEFAULT_MINUTE);
			} else {
				dateTime = WebUtility.getDaTeTime(hrreading.getReading(), hrreading.getHour(), hrreading.getMinute());
			}
		}
		hrreading.setReading(dateTime);
		hrreading.setUserprofileId(getUserProfileId());
		return hrreading;
	}

	public String saveAndAdd() {
		String outcome = null;
		try {
			if (saveHRReading().getHeartRateId() != null) {
				outcome = "addHRDisplay";
				saveAndAddMessage = true;
				hrreadings = findHRReadings(userprofileId);
				newHRReading = new HeartRateReadingDTO();
				newHRReading.setReading(new Date());
			}

		} catch (MHVException e) {

			log.error("Failed to Save HeartRate record", e);

			if (e.getValidationErrorMessages() != null) {
				addValidationMessages(e.getValidationErrorMessages());
			} else {
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}
		}
		return outcome;
	}

	public String updateLineModel() {
		return "heartRateGraph";
	}

	public StreamedContent getJchart() {
		StreamedContent content = null;
		try {
			content = createChart(TITLE, XAXIS, YAXIS);
		} catch (Exception e) {
			log.error("Failed to create Chart", e);
		}
		return content;
	}

	protected XYDataset createDataset(Set<String> uniqueYears) {
		TimeSeriesCollection dataset = new TimeSeriesCollection();
		TimeSeries series1 = new TimeSeries(SERIES1);
		String period = getPeriod();
		Date startDate = null;
		List<HeartRateReadingDTO> graphList;
		if (!period.equals(PeriodEnumeration.ALL_DATA.getDescription())) {
			startDate = getStartGraphDate(period);
		}
		if (startDate != null) {
			graphList = getGraphlist(hrreadings, startDate);
		} else {
			graphList = hrreadings;
		}
		for (HeartRateReadingDTO hrreading : graphList) {
			series1.addOrUpdate(new Day(hrreading.getReading()), hrreading.getHeartRate());
			uniqueYears
					.add(CommonUtility.dateToString(hrreading.getReading(), YYYY_MM_DD_HHMMSS_FORMAT).substring(0, 4));
		}
		dataset.addSeries(series1);
		return dataset;
	}

	private List<HeartRateReadingDTO> getGraphlist(List<HeartRateReadingDTO> hreadings, Date startDate) {
		List<HeartRateReadingDTO> graphList = new ArrayList<HeartRateReadingDTO>();
		Integer startdateValue = Integer.valueOf(CommonUtility.dateToString(startDate, YYYYMMDD_FORMAT));
		for (HeartRateReadingDTO hreading : hreadings) {
			Integer readingValue = Integer.valueOf(CommonUtility.dateToString(hreading.getReading(), YYYYMMDD_FORMAT));
			if (readingValue >= startdateValue) {
				graphList.add(hreading);
			}
		}
		return graphList;
	}

	/**
	 * @return the hrreadings
	 */
	public List<HeartRateReadingDTO> getHrreadings() {
		return hrreadings;
	}

	/**
	 * @param hrreadings
	 *            the hrreadings to set
	 */
	public void setHrreadings(List<HeartRateReadingDTO> hrreadings) {
		this.hrreadings = hrreadings;
	}

	/**
	 * @return the hrTable
	 */
	public DataTable getHrTable() {
		return hrTable;
	}

	/**
	 * @param hrTable
	 *            the hrTable to set
	 */
	public void setHrTable(DataTable hrTable) {
		this.hrTable = hrTable;
	}

	/**
	 * @return the selectedHRReading
	 */
	public HeartRateReadingDTO getSelectedHRReading() {
		return selectedHRReading;
	}

	/**
	 * @param selectedHRReading
	 *            the selectedHRReading to set
	 */
	public void setSelectedHRReading(HeartRateReadingDTO selectedHRReading) {
		this.selectedHRReading = selectedHRReading;
	}

	/**
	 * @return the newHRReading
	 */
	public HeartRateReadingDTO getNewHRReading() {
		return newHRReading;
	}

	/**
	 * @param newHRReading
	 *            the newHRReading to set
	 */
	public void setNewHRReading(HeartRateReadingDTO newHRReading) {
		this.newHRReading = newHRReading;
	}

}
