package gov.va.med.mhv.vitals.web.controller;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.primefaces.model.DefaultStreamedContent;
import org.primefaces.model.StreamedContent;
import org.primefaces.model.chart.DateAxis;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

import gov.va.med.mhv.vitals.enums.PeriodEnumeration;
import gov.va.med.mhv.vitals.service.VitalSignsService;

@PropertySources(value = {
	@PropertySource("classpath:/${MHV_ENV_PROPERTY}.vitalsigns.portlet.properties") 
})
public abstract class AbstractController implements Serializable {

	private static final long serialVersionUID = -8611610134485398648L;
	private static Logger log = LogManager.getLogger(AbstractController.class);
	private String firstName;
	private String lastName;
	protected static final String  DEFAULT_HOUR ="23";
	protected static final String  DEFAULT_MINUTE ="59";
	protected static final String  DEFAULT_DATETIME ="23:59";
	protected static final String  HOUR_MINUTE ="HH:mm";
	protected static final String  HOURS ="HH";
	protected static final String  MINUTES ="mm";
	protected Boolean saveMessage = false;
	protected Boolean saveAndAddMessage = false;
	protected Boolean deleteMessage = false;
	protected String period = PeriodEnumeration.ONE_MONTH.getDescription();
	protected static final String  YYYYMMDD_FORMAT ="yyyyMMdd";
	protected static final String  YYYY_MM_DD_HHMMSS_FORMAT="yyyy-MM-dd";
	protected static final String CHART_EXTENDER="chartExtender";
	protected static final String DAYS ="dd";
	protected static final String MONTHS="MM";
	protected static final String YEARS="yyyy";
	protected static final String NO_DATA="No data available";
	private static final String IMG_FORMAT="png";
	private static final String IMG_PNG_FORMAT="image/png";
	protected static final String ERR_PRCS_RQST="Error Processing request";
	protected static final String CONTENT_TYPE="application/json";
	private String deleteOrigin;
	
	protected ValueExpression sortColumn;
	protected String sortBy;
	protected Long userprofileId;
	protected int rowsPerPage;
	
	@Resource(name="vitalsSignsServiceProxy")
	protected VitalSignsService vitalSignsService;
	
	@Value("${appContextroot}")
	private String appContextRoot;

	private String getAppContextRoot() {
		return appContextRoot;
	}
	
	public String getMhvContext(){
		String context = PropsUtil.get("mhv.context");
		return  context;
    }

	public void findUser() {
		PortletRequest   request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user=null;
        try{
        	user = PortalUtil.getUser(request);
        }catch(Exception e){
        	
        }
		if(user != null){
			setFirstName(user.getFirstName());
			setLastName(user.getLastName());
		}
	}
	
	protected Long getUserProfileId() {
		Long userprofileId = null;
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		Object profileId = session.getAttribute("LIFERAY_SHARED_userprofileid",
				PortletSession.APPLICATION_SCOPE);
		if (profileId != null) {
			userprofileId = (Long) profileId;
		}
		return userprofileId;
	}
	
	protected void resetMessages(){
		saveMessage = false;
		saveAndAddMessage = false;
		deleteMessage = false;
	}
	
	public PeriodEnumeration[] getPeriods(){
		return PeriodEnumeration.values();
	}

	protected Date getStartGraphDate(String period) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		if(period.equals(PeriodEnumeration.ONE_WEEK.getDescription())){
			cal.add(Calendar.WEEK_OF_YEAR, -1);
		}else if(period.equals(PeriodEnumeration.TWO_WEEKS.getDescription())){
			cal.add(Calendar.WEEK_OF_YEAR, -2);
		}else if (period.equals(PeriodEnumeration.ONE_MONTH.getDescription())){
			cal.add(Calendar.MONTH, -1);
		}else if (period.equals(PeriodEnumeration.SIX_MONTHS.getDescription())){
			cal.add(Calendar.MONTH, -6);
		}else if (period.equals(PeriodEnumeration.ONE_YEAR.getDescription())){
			cal.add(Calendar.YEAR, -1);
		}else if(period.equals(PeriodEnumeration.TWO_YEARS.getDescription())){
			cal.add(Calendar.YEAR, -2);
		}
		return cal.getTime();
	}
	
	protected void setTickValues(DateAxis axis, String period, Set<String>  uniqueYears) {
		if(uniqueYears.size() > 1){
			axis.setTickFormat("%b  %Y");
		}else{
			axis.setTickFormat("%b  %#d");
			axis.setTickInterval("86400000");
		}
	}
	
	
	protected StreamedContent createChart(String title,String xaxis,String yaxis) throws Exception{
		Set<String> uniqueYears = new HashSet<String>();
		XYDataset dataset=createDataset(uniqueYears);
		JFreeChart chart = ChartFactory.createTimeSeriesChart(title, xaxis, yaxis, dataset, true, true, false );
		chart.setBackgroundPaint(Color.white);
        XYPlot plot = (XYPlot) chart.getPlot();
        plot.setBackgroundPaint(Color.white);
        plot.setDomainGridlinePaint(Color.gray);
        plot.setRangeGridlinePaint(Color.gray);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        setValueRanges(plot);
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer) r;
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
            renderer.setDrawSeriesLineAsPath(true);
        }
        org.jfree.chart.axis.DateAxis axis = (org.jfree.chart.axis.DateAxis) plot.getDomainAxis();
        axis.setDateFormatOverride(null);
        if(uniqueYears.size() > 1){
        	axis.setDateFormatOverride(new SimpleDateFormat("MMM-yyyy"));
        }else{
        	axis.setDateFormatOverride(new SimpleDateFormat("MMM-dd"));
        }
        axis.setVerticalTickLabels(true);
        
        ValueAxis valax = plot.getRangeAxis();
        valax.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setRangeAxis(valax);
        
        plot.setNoDataMessage(NO_DATA);
		BufferedImage image = chart.createBufferedImage(400, 400);
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		ImageIO.write(image,IMG_FORMAT,os); 
		InputStream is = new ByteArrayInputStream(os.toByteArray());
		StreamedContent content = new DefaultStreamedContent(is,IMG_PNG_FORMAT);
        return content; 
	}

	protected void setValueRanges(XYPlot plot) {
		
	}

	protected XYDataset createDataset(Set<String> uniqueYears) {
		return null;
	}
		

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public Boolean getSaveMessage() {
		return saveMessage;
	}

	public void setSaveMessage(Boolean saveMessage) {
		this.saveMessage = saveMessage;
	}

	public Boolean getSaveAndAddMessage() {
		return saveAndAddMessage;
	}

	public void setSaveAndAddMessage(Boolean saveAndAddMessage) {
		this.saveAndAddMessage = saveAndAddMessage;
	}

	public Boolean getDeleteMessage() {
		return deleteMessage;
	}

	public void setDeleteMessage(Boolean deleteMessage) {
		this.deleteMessage = deleteMessage;
	}

	public String getPeriod() {
		return period;
	}

	public void setPeriod(String period) {
		this.period = period;
	}

	public String getDeleteOrigin() {
		return deleteOrigin;
	}

	public void setDeleteOrigin(String deleteOrigin) {
		this.deleteOrigin = deleteOrigin;
	}
	
	public ValueExpression getSortColumn() {
		return sortColumn;
	}

	public void setSortColumn(ValueExpression sortColumn) {
		this.sortColumn = sortColumn;
	}

	public String getSortBy() {
		return sortBy;
	}

	public void setSortBy(String sortBy) {
		this.sortBy = sortBy;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

	public int getRowsPerPage() {
		return rowsPerPage;
	}

	public void setRowsPerPage(int rowsPerPage) {
		this.rowsPerPage = rowsPerPage;
	}
	
	protected void addValidationMessages(Map<String, String> validationMessages) {
		if(validationMessages != null) {
			for (Map.Entry<String, String> entry : validationMessages.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
	}
}
