package gov.va.med.mhv.vitals.validator;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.dto.BloodSugarReadingDTO;
import gov.va.med.mhv.vitals.enums.BloodSugarTestingMethodEnumeration;
import gov.va.med.mhv.vitals.util.MessagesUtil;

@Component
public class BloodSugarValidator extends Validator{
	
	public static final int COMMENTS_MAX_LENGTH = 255;
	private static final Integer BLOODSUGARCOUNT_MIN_VALUE = new Integer("1");
	private static final Integer BLOODSUGARCOUNT_MAX_VALUE = new Integer("999");
	public static final String BLOOD_SUGAR="Blood Sugar";
	public static final String TESTING_METHOD="Testing Method";
	

	
	@Autowired
	private MessagesUtil messages;
	
	public void bloodSugarValidations(ResponseUtil response, BloodSugarReadingDTO bsdto) {
		fieldValidation(response, bsdto);
	}

	private void fieldValidation(ResponseUtil response,	BloodSugarReadingDTO bsdto) {
		validateComments(response,bsdto);
		validateTestingMethod(response,bsdto);
		validateBloodSugarCount(response,bsdto);
		validateReadingDate(response,bsdto);
	}

	private void validateReadingDate(ResponseUtil response,	BloodSugarReadingDTO bsdto) {
		Date value = bsdto.getReading();
		if( value == null ) {
			Validations.validateRequired("dateEntered", value, response.getValidationErrors());
			return;
		}		
	}

	private void validateBloodSugarCount(ResponseUtil response,	BloodSugarReadingDTO bsdto) {
		Integer value = bsdto.getBloodSugarCount();
		if( value == null ) {
			Validations.validateRequired(BLOOD_SUGAR, value, response.getValidationErrors());
			return;
		}		
		Validations.validateMinValue("bloodsugar minimum", value, BLOODSUGARCOUNT_MIN_VALUE,BLOOD_SUGAR, response.getValidationErrors());
		Validations.validateMaxValue("bloodsugar maximum",value, BLOODSUGARCOUNT_MAX_VALUE,BLOOD_SUGAR,response.getValidationErrors());
	}

	private void validateTestingMethod(ResponseUtil response,BloodSugarReadingDTO bsdto) {
		String value = bsdto.getTestingMethod();
		if( value == null ) {
			Validations.validateRequired(value, TESTING_METHOD, response.getValidationErrors());
			return;
		}		
		Validations.validateEnumeration(TESTING_METHOD, value, BloodSugarTestingMethodEnumeration.values(), response.getValidationErrors());
	}

	private void validateComments(ResponseUtil response,BloodSugarReadingDTO bsdto) {
		String value = bsdto.getComments();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength("comments",value, COMMENTS_MAX_LENGTH, response.getValidationErrors());
	}

}
