package gov.va.med.mhv.vitals.service.impl;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.converter.PainConverter;
import gov.va.med.mhv.vitals.dto.PainReadingDTO;
import gov.va.med.mhv.vitals.model.PainReading;
import gov.va.med.mhv.vitals.repository.PainReadingRepository;
import gov.va.med.mhv.vitals.service.PainService;
import gov.va.med.mhv.vitals.validator.PainValidator;

@Component
public class PainServiceImpl implements PainService {
	
	private static Logger log = LogManager.getLogger(PainServiceImpl.class);
	
	@Autowired
	private PainReadingRepository painRepository;
	
	@Autowired
	private PainValidator validator;


	@Override
	public ResponseUtil<Long> save(PainReadingDTO painDTO) {
		ResponseUtil<Long> response = new ResponseUtil<Long>();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.painValidations(response, painDTO);
		if(response.getValidationErrors().size() == 0){
			PainReading painReading = PainConverter.convertPainReadingDTO(painDTO);
			painReading = painRepository.save(painReading);
			response.setSuccess(true);
			response.setPojoObject(painReading.getId());
		}else{
			log.debug("Validation Errors in save Pain reading:");
			response.setFailure(true);
		}
		return response;
	}

	@Override
	public ResponseUtil<Void> delete(Long id) {
		ResponseUtil<Void> response = new ResponseUtil<Void>();
		painRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		PainReading painReading = painRepository.findOne(id);
		if(painReading != null){
			PainReadingDTO painDTO = PainConverter.convertPainReadingDomain(painReading);
			response.setPojoObject(painDTO);
			response.setSuccess(true);
		}else{
			log.debug("Pain Record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil<List<PainReadingDTO>> getPainReadingsForUser(Long userprofileid) {
		ResponseUtil<List<PainReadingDTO>> response = new ResponseUtil<List<PainReadingDTO>>();
		List<PainReading> painReadings=painRepository.getPainReadingsForUser(userprofileid);
		if(painReadings != null){
			List<PainReadingDTO> dtos = PainConverter.convertPainReadings(painReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("Pain Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<List<PainReadingDTO>> getPainDashBoardReadingsForUser(Long userprofileid) {
		ResponseUtil<List<PainReadingDTO>> response = new ResponseUtil<List<PainReadingDTO>>();
		Pageable topFive = new  PageRequest(0,5);
		List<PainReading> painReadings=painRepository.getDashBoardPainReadingsForUser(userprofileid, topFive);
		if(painReadings != null){
			List<PainReadingDTO> dtos = PainConverter.convertPainReadings(painReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("Pain Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<PainReadingDTO> getPainReadingByid(Long userProfileId, Long id) {
		ResponseUtil<PainReadingDTO> response = new ResponseUtil<PainReadingDTO>();
		PainReading painReading = painRepository.findOne(id);
		if(painReading != null){
			PainReadingDTO dto=PainConverter.convertPainReadingDomain(painReading);
			response.setPojoObject(dto);
		}else{
			log.debug("Pain Record not found for Id:");
			log.debug(id);
		}
		response.setSuccess(true);
		return response;
	}
}
