package gov.va.med.mhv.vitals.service.impl;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.converter.InrConverter;
import gov.va.med.mhv.vitals.dto.InrReadingDTO;
import gov.va.med.mhv.vitals.model.InrReading;
import gov.va.med.mhv.vitals.repository.InrReadingRepository;
import gov.va.med.mhv.vitals.service.InrService;
import gov.va.med.mhv.vitals.validator.InrValidator;

@Component
public class InrServiceImpl implements InrService{
	
	private static Logger log = LogManager.getLogger(InrServiceImpl.class);
	
	@Autowired
	private InrReadingRepository inrRepository;
	
	@Autowired
	private InrValidator validator;


	@Override
	public ResponseUtil<Long> save(InrReadingDTO inrDTO) {
		ResponseUtil<Long> response = new ResponseUtil<Long>();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.inrReadingValidations(response, inrDTO);
		if(response.getValidationErrors().size() == 0){
			InrReading inrReading = InrConverter.convertInrReadingDTO(inrDTO);
			inrReading = inrRepository.save(inrReading);
			response.setSuccess(true);
			response.setPojoObject(inrReading.getId());
		}else{
			log.debug("Validation Errors in save INR  reading:");
			response.setFailure(true);
		}
		return response;
	}

	@Override
	public ResponseUtil<Void> delete(Long id) {
		ResponseUtil<Void> response = new ResponseUtil<Void>();
		inrRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		InrReading inrReading = inrRepository.findOne(id);
		if(inrReading != null){
			InrReadingDTO inrDTO = InrConverter.convertInrReadingDomain(inrReading);
			response.setPojoObject(inrDTO);
			response.setSuccess(true);
		}else{
			log.debug("INR Record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil<List<InrReadingDTO>> getInrReadingsForUser(Long userprofileid) {
		ResponseUtil<List<InrReadingDTO>> response = new ResponseUtil<List<InrReadingDTO>>();
		List<InrReading> inrReadings=inrRepository.getInrReadingsForUser(userprofileid);
		if(inrReadings != null){
			List<InrReadingDTO> dtos = InrConverter.convertInrReadings(inrReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("INR Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<List<InrReadingDTO>> getInrDashBoardReadingsForUser(Long userprofileid) {
		ResponseUtil<List<InrReadingDTO>> response = new ResponseUtil<List<InrReadingDTO>>();
		Pageable topFive = new  PageRequest(0,5);
		List<InrReading> inrReadings=inrRepository.getDashBoardInrReadingsForUser(userprofileid, topFive);
		if(inrReadings != null){
			List<InrReadingDTO> dtos = InrConverter.convertInrReadings(inrReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("INR Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<InrReadingDTO> getINRReadingByid(Long userProfileId, Long id) {
		ResponseUtil<InrReadingDTO> response = new ResponseUtil<InrReadingDTO>();
		InrReading inrReading = inrRepository.findOne(id);
		if(inrReading != null){
			InrReadingDTO dto=InrConverter.convertInrReadingDomain(inrReading);
			response.setPojoObject(dto);
		}else{
			log.debug("INR Record not found for Id:");
			log.debug(id);
		}
		response.setSuccess(true);
		return response;
	}

}
