package gov.va.med.mhv.vitals.service.impl;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.converter.BodyWeightConverter;
import gov.va.med.mhv.vitals.dto.BodyWeightReadingDTO;
import gov.va.med.mhv.vitals.model.BodyWeightReading;
import gov.va.med.mhv.vitals.repository.BodyWeightReadingRepository;
import gov.va.med.mhv.vitals.service.BodyWeightService;
import gov.va.med.mhv.vitals.validator.BodyWeightValidator;

@Component
public class BodyWeightServiceImpl  implements BodyWeightService{
	
	private static Logger log = LogManager.getLogger(BodyWeightServiceImpl.class);

	@Autowired
	private BodyWeightReadingRepository bwRepository;
	
	@Autowired
	private BodyWeightValidator validator;

	@Override
	public ResponseUtil<Long> save(BodyWeightReadingDTO bwDTO) {
		ResponseUtil<Long> response = new ResponseUtil<Long>();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.bodyWeightValidations(response, bwDTO);
		if(response.getValidationErrors().size() == 0){
			BodyWeightReading bwReading = BodyWeightConverter.convertBWReadingDTO(bwDTO);
			bwReading = bwRepository.save(bwReading);
			response.setSuccess(true);
			response.setPojoObject(bwReading.getId());
		}else{
			log.debug("Validation Errors in save Bodyweight reading:");
			response.setFailure(true);
		}
		return response;
	}

	@Override
	public ResponseUtil<Void> delete(Long id) {
		ResponseUtil<Void> response = new ResponseUtil<Void>();
		bwRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		BodyWeightReading bwReading = bwRepository.findOne(id);
		if(bwReading != null){
			BodyWeightReadingDTO bwReadingDTO = BodyWeightConverter.convertBWReadingDomain(bwReading);
			response.setPojoObject(bwReadingDTO);
			response.setSuccess(true);
		}else{
			log.debug("BodyWeight Record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil<List<BodyWeightReadingDTO>> getBWReadingsForUser(Long userprofileid) {
		ResponseUtil<List<BodyWeightReadingDTO>> response = new ResponseUtil<List<BodyWeightReadingDTO>>();
		List<BodyWeightReading> bwReadings=bwRepository.getBWReadingsForUser(userprofileid);
		if(bwReadings != null){
			List<BodyWeightReadingDTO> dtos = BodyWeightConverter.convertBWReadings(bwReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("BodyWeight Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<List<BodyWeightReadingDTO>> getBWDashBoardReadingsForUser(Long userprofileid) {
		ResponseUtil<List<BodyWeightReadingDTO>> response = new ResponseUtil<List<BodyWeightReadingDTO>>();
		Pageable topFive = new  PageRequest(0,5);
		List<BodyWeightReading> bwReadings=bwRepository.getDashBoardBWReadingsForUser(userprofileid, topFive);
		if(bwReadings != null){
			List<BodyWeightReadingDTO> dtos = BodyWeightConverter.convertBWReadings(bwReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("BodyWeight Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}
	
	
	@Override
	public ResponseUtil<BodyWeightReadingDTO> getBWReadingByid(Long userProfileId, Long id) {
		ResponseUtil<BodyWeightReadingDTO> response = new ResponseUtil<BodyWeightReadingDTO>();
		BodyWeightReading bwReading = bwRepository.findOne(id);
		if(bwReading != null){
			BodyWeightReadingDTO dto=BodyWeightConverter.convertBWReadingDomain(bwReading);
			response.setPojoObject(dto);
		}else{
			log.debug("Body Weight Record not found for Id:");
			log.debug(id);
		}
		response.setSuccess(true);
		return response;
	}


	public BodyWeightReadingRepository getBwRepository() {
		return bwRepository;
	}

	public void setBwRepository(BodyWeightReadingRepository bwRepository) {
		this.bwRepository = bwRepository;
	}

	public BodyWeightValidator getValidator() {
		return validator;
	}

	public void setValidator(BodyWeightValidator validator) {
		this.validator = validator;
	}

}
