package gov.va.med.mhv.vitals.service.impl;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.converter.BodyTemperatureConverter;
import gov.va.med.mhv.vitals.dto.BodyTemperatureDTO;
import gov.va.med.mhv.vitals.model.BodyTemperatureReading;
import gov.va.med.mhv.vitals.repository.BodyTemperatureRepository;
import gov.va.med.mhv.vitals.service.BodyTemperatureService;
import gov.va.med.mhv.vitals.validator.BodyTemperatureValidator;

@Component
public class BodyTemperatureServiceImpl implements BodyTemperatureService{
	
	private static Logger log = LogManager.getLogger(BodyTemperatureServiceImpl.class);
	
	@Autowired
	private BodyTemperatureRepository temperatureRepository;
	
	@Autowired
	private BodyTemperatureValidator validator;


	@Override
	public ResponseUtil<Long> save(BodyTemperatureDTO bodyTemperatureDTO) {
		ResponseUtil<Long> response = new ResponseUtil<Long>();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.temperatureReadingValidations(response, bodyTemperatureDTO);
		if(response.getValidationErrors().size() == 0){
			BodyTemperatureReading tempReading = BodyTemperatureConverter.convertBodytempReadingDTO(bodyTemperatureDTO);
			tempReading = temperatureRepository.save(tempReading);
			response.setSuccess(true);
			response.setPojoObject(tempReading.getId());
		}else{
			log.debug("Validation Errors in save Temperature reading:");
			response.setFailure(true);
		}
		return response;
	}

	@Override
	public ResponseUtil<Void> delete(Long id) {
		ResponseUtil<Void> response = new ResponseUtil<Void>();
		temperatureRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		BodyTemperatureReading tempReading = temperatureRepository.findOne(id);
		if(tempReading != null){
			BodyTemperatureDTO tempReadingDTO = BodyTemperatureConverter.convertBodytempReadingDomain(tempReading);
			response.setPojoObject(tempReadingDTO);
			response.setSuccess(true);
		}else{
			log.debug("Temperature Record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil<List<BodyTemperatureDTO>> getTemperatureReadingsForUser(Long userprofileid) {
		ResponseUtil<List<BodyTemperatureDTO>> response = new ResponseUtil<List<BodyTemperatureDTO>>();
		List<BodyTemperatureReading> tempReadings=temperatureRepository.getTemperatureReadingsForUser(userprofileid);
		if(tempReadings != null){
			List<BodyTemperatureDTO> dtos = BodyTemperatureConverter.convertBodytempReadings(tempReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("Temperature Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<List<BodyTemperatureDTO>> getTemperatureDashBoardReadingsForUser(	Long userprofileid) {
		ResponseUtil<List<BodyTemperatureDTO>> response = new ResponseUtil<List<BodyTemperatureDTO>>();
		Pageable topFive = new  PageRequest(0,5);
		List<BodyTemperatureReading> tempReadings=temperatureRepository.getDashBoardTemperatureReadingsForUser(userprofileid, topFive);
		if(tempReadings != null){
			List<BodyTemperatureDTO> dtos = BodyTemperatureConverter.convertBodytempReadings(tempReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("Temperature Dash board Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<BodyTemperatureDTO> getTemperatureReadingByid(Long userProfileId, Long id) {
		ResponseUtil<BodyTemperatureDTO> response = new ResponseUtil<BodyTemperatureDTO>();
		BodyTemperatureReading tempReading = temperatureRepository.findOne(id);
		if(tempReading != null){
			BodyTemperatureDTO dto=BodyTemperatureConverter.convertBodytempReadingDomain(tempReading);
			response.setPojoObject(dto);
		}else{
			log.debug("Temperature Record not found for Id:");
			log.debug(id);
		}
		response.setSuccess(true);
		return response;
	}

}
