package gov.va.med.mhv.vitals.converter;

import gov.va.med.mhv.vitals.dto.InrReadingDTO;
import gov.va.med.mhv.vitals.model.InrReading;

import java.util.ArrayList;
import java.util.List;

public class InrConverter {
	
	public static InrReadingDTO  convertInrReadingDomain( InrReading inrReading ){
		InrReadingDTO dto = new InrReadingDTO();
		dto.setComments(inrReading.getComments());
		dto.setHighendTragetRange(inrReading.getHighendTragetRange());
		dto.setInr(inrReading.getInr());
		dto.setInrId(inrReading.getId());
		dto.setLocation(inrReading.getLocation());
		dto.setLowendTargetRange(inrReading.getLowendTargetRange());
		dto.setProvider(inrReading.getProvider());
		dto.setReading(inrReading.getReading());
		dto.setUserprofileId(inrReading.getUserprofileId());
		return dto;
	}
	
	public static InrReading convertInrReadingDTO(InrReadingDTO inrReadingDTO){
		InrReading inrReading = new InrReading();
		inrReading.setComments(inrReadingDTO.getComments());
		inrReading.setHighendTragetRange(inrReadingDTO.getHighendTragetRange());
		inrReading.setId(inrReadingDTO.getInrId());
		inrReading.setInr(inrReadingDTO.getInr());
		inrReading.setLocation(inrReadingDTO.getLocation());
		inrReading.setLowendTargetRange(inrReadingDTO.getLowendTargetRange());
		inrReading.setOplock(0);
		inrReading.setProvider(inrReadingDTO.getProvider());
		inrReading.setReading(inrReadingDTO.getReading());
		inrReading.setUserprofileId(inrReadingDTO.getUserprofileId());
		return inrReading;
		
	}
	
	public static List<InrReadingDTO>  convertInrReadings( List<InrReading> inrReadings ){
		List<InrReadingDTO> inrReadingDTOS = new ArrayList<InrReadingDTO>();
		for(InrReading inrReading : inrReadings){
			InrReadingDTO dto = convertInrReadingDomain(inrReading);
			inrReadingDTOS.add(dto);
		}
		return inrReadingDTOS;
	}

}
