package gov.va.med.mhv.vitals.converter;

import gov.va.med.mhv.vitals.dto.HeartRateReadingDTO;
import gov.va.med.mhv.vitals.model.HeartRateReading;

import java.util.ArrayList;
import java.util.List;

public class HeartRateConverter {
	
	public static HeartRateReadingDTO  convertHeartRateReadingDomain( HeartRateReading hrReading ){
		HeartRateReadingDTO dto = new HeartRateReadingDTO();
		dto.setComments(hrReading.getComments());
		dto.setHeartRate(hrReading.getHeartRate());
		dto.setHeartRateId(hrReading.getId());
		dto.setReading(hrReading.getReading());
		dto.setUserprofileId(hrReading.getUserprofileId());
		return dto;
	}
	
	
	public static HeartRateReading convertHeartRateReadingDTO(HeartRateReadingDTO hrReadingDTO){
		HeartRateReading hrReading = new HeartRateReading();
		hrReading.setComments(hrReadingDTO.getComments());
		hrReading.setHeartRate(hrReadingDTO.getHeartRate());
		hrReading.setId(hrReadingDTO.getHeartRateId());
		hrReading.setOplock(0);
		hrReading.setReading(hrReadingDTO.getReading());
		hrReading.setUserprofileId(hrReadingDTO.getUserprofileId());
		return hrReading;
	}
	
	
	public static List<HeartRateReadingDTO>  convertHeartRateReadings( List<HeartRateReading> hrReadings ){
		List<HeartRateReadingDTO> hrReadingDTOS = new ArrayList<HeartRateReadingDTO>();
		for(HeartRateReading hrReading : hrReadings){
			HeartRateReadingDTO dto = convertHeartRateReadingDomain(hrReading);
			hrReadingDTOS.add(dto);
		}
		return hrReadingDTOS;
	}

}
