package gov.va.med.mhv.vitals.converter;

import gov.va.med.mhv.vitals.dto.BloodSugarReadingDTO;
import gov.va.med.mhv.vitals.model.BloodSugarReading;

import java.util.ArrayList;
import java.util.List;

public class BloodSugarConverter {
	
	public static BloodSugarReadingDTO  convertBloodSugarReadingDomain( BloodSugarReading bsReading ){
		BloodSugarReadingDTO dto = new BloodSugarReadingDTO();
		dto.setBloodSugarCount(bsReading.getBloodSugarCount());
		dto.setBloodSugarId(bsReading.getId());
		dto.setComments(bsReading.getComments());
		dto.setReading(bsReading.getReading());
		dto.setTestingMethod(bsReading.getTestingMethod());
		dto.setUserprofileId(bsReading.getUserprofileId());
		return dto;
	}
	
	public static BloodSugarReading convertBloodSugarReadingDTO(BloodSugarReadingDTO bsReadingDTO){
		BloodSugarReading bsReading = new BloodSugarReading();
		bsReading.setBloodSugarCount(bsReadingDTO.getBloodSugarCount());
		bsReading.setComments(bsReadingDTO.getComments());
		bsReading.setId(bsReadingDTO.getBloodSugarId());
		bsReading.setOplock(0);
		bsReading.setReading(bsReadingDTO.getReading());
		bsReading.setTestingMethod(bsReadingDTO.getTestingMethod());
		bsReading.setUserprofileId(bsReadingDTO.getUserprofileId());
		return bsReading;
	}
	
	public static List<BloodSugarReadingDTO>  convertBloodSugarReadings( List<BloodSugarReading> bsReadings ){
		List<BloodSugarReadingDTO> bsReadingDTOS = new ArrayList<BloodSugarReadingDTO>();
		for(BloodSugarReading bsReading : bsReadings){
			BloodSugarReadingDTO dto = convertBloodSugarReadingDomain(bsReading);
			bsReadingDTOS.add(dto);
		}
		return  bsReadingDTOS;
	}
}
