package gov.va.med.mhv.vitals.repository;

import gov.va.med.mhv.vitals.model.BodyTemperatureReading;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface BodyTemperatureRepository extends JpaRepository<BodyTemperatureReading, Long>{
	
    @Query("select a from BodyTemperatureReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<BodyTemperatureReading>  getTemperatureReadingsForUser(@Param ("userprofileid") Long userprofileid);
    
    
    @Query("select a from BodyTemperatureReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<BodyTemperatureReading>  getDashBoardTemperatureReadingsForUser(@Param ("userprofileid") Long userprofileid,Pageable page);


	

}
