package gov.va.med.mhv.vitals.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="PULSE_OXIMETRY_READINGS")
public class PulseOximetryReading implements Serializable {
	
	private static final long serialVersionUID = 325724624800440396L;
	
	@Id
	@Column(name="PULSE_OXIMETRY_ID_SEQ")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@Column(name="OPLOCK")
	private Integer oplock;
 
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="SUPP_OXYGEN_DEVICE")
	private String suppOxygenDevice;
	
	@Column(name="OXYGEN_SETTING")
	private Integer oxygenSetting;
	
	@Column(name="RESPIRATORY_RATE")
	private Integer respiratoryRate;
	
	@Column(name="OXIMETER_READING")
	private Integer oximeterReading;
	
	@Column(name="OTHER_SYMPTOMS")
	private String otherSymptoms;
	
	@Column(name="SYMPTOMS")
	private String symptoms;

	
	@Column(name="READING")
	private Date reading;
	
	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getSuppOxygenDevice() {
		return suppOxygenDevice;
	}

	public void setSuppOxygenDevice(String suppOxygenDevice) {
		this.suppOxygenDevice = suppOxygenDevice;
	}

	public Integer getOxygenSetting() {
		return oxygenSetting;
	}

	public void setOxygenSetting(Integer oxygenSetting) {
		this.oxygenSetting = oxygenSetting;
	}

	public Integer getRespiratoryRate() {
		return respiratoryRate;
	}

	public void setRespiratoryRate(Integer respiratoryRate) {
		this.respiratoryRate = respiratoryRate;
	}

	public Integer getOximeterReading() {
		return oximeterReading;
	}

	public void setOximeterReading(Integer oximeterReading) {
		this.oximeterReading = oximeterReading;
	}

	public String getOtherSymptoms() {
		return otherSymptoms;
	}

	public void setOtherSymptoms(String otherSymptoms) {
		this.otherSymptoms = otherSymptoms;
	}

	public String getSymptoms() {
		return symptoms;
	}

	public void setSymptoms(String symptoms) {
		this.symptoms = symptoms;
	}

	public Date getReading() {
		return reading;
	}

	public void setReading(Date reading) {
		this.reading = reading;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}


}
