package gov.va.med.mhv.vitals.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="PAIN_ENTRIES")
public class PainReading implements Serializable{
	
	private static final long serialVersionUID = -7369510170970100193L;
	
	@Id
	@Column(name="PAIN_ID_SEQ")
	@GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
	
	@Column(name="OPLOCK")
	private Integer oplock;
	
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="PAIN_LEVEL")
    private Integer painLevel;
	
	
	@Column(name="READING_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date reading;

	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Integer getPainLevel() {
		return painLevel;
	}

	public void setPainLevel(Integer painLevel) {
		this.painLevel = painLevel;
	}

	public Date getReading() {
		return reading;
	}

	public void setReading(Date reading) {
		this.reading = reading;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

}
