package gov.va.med.mhv.vitals.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="INR_READINGS")
public class InrReading implements Serializable {
	
	private static final long serialVersionUID = -4920334441407274144L;
	
	@Id
	@Column(name="INR_ID")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@Column(name="OPLOCK")
	private Integer oplock;
 
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="READING")
	private Date reading;
	
	@Column(name="INR")
	private BigDecimal inr;
	
	@Column(name="LOW_END_TARGET_RANGE")
	private String lowendTargetRange;
	
	@Column(name="HIGH_END_TARGET_RANGE")
	private String highendTragetRange;
	
	@Column(name="LOCATION")
	private String location;
	
	@Column(name="PROVIDER")
	private String provider;

	
	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;


	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}


	public Integer getOplock() {
		return oplock;
	}


	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}


	public String getComments() {
		return comments;
	}


	public void setComments(String comments) {
		this.comments = comments;
	}


	public Date getReading() {
		return reading;
	}


	public void setReading(Date reading) {
		this.reading = reading;
	}


	public BigDecimal getInr() {
		return inr;
	}


	public void setInr(BigDecimal inr) {
		this.inr = inr;
	}


	public String getLowendTargetRange() {
		return lowendTargetRange;
	}


	public void setLowendTargetRange(String lowendTargetRange) {
		this.lowendTargetRange = lowendTargetRange;
	}


	public String getHighendTragetRange() {
		return highendTragetRange;
	}


	public void setHighendTragetRange(String highendTragetRange) {
		this.highendTragetRange = highendTragetRange;
	}


	public String getLocation() {
		return location;
	}


	public void setLocation(String location) {
		this.location = location;
	}


	public String getProvider() {
		return provider;
	}


	public void setProvider(String provider) {
		this.provider = provider;
	}


	public Long getUserprofileId() {
		return userprofileId;
	}


	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

}
