package gov.va.med.mhv.vitals.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="BODY_WEIGHT_READINGS")
public class BodyWeightReading implements Serializable{
	
	private static final long serialVersionUID = -1743089020648284878L;
	
	@Id
	@Column(name="BODY_WEIGHT_ID_SEQ")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@Column(name="OPLOCK")
	private Integer oplock;
	
	@Column(name="BODY_WEIGHT")
	private BigDecimal bodyweight;
	
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="BODY_WEIGHT_MEASURE")
	private String bodyweightMeasure;

	@Column(name="READING")
	@Temporal(TemporalType.TIMESTAMP)
	private Date reading;
	
	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public BigDecimal getBodyweight() {
		return bodyweight;
	}

	public void setBodyweight(BigDecimal bodyweight) {
		this.bodyweight = bodyweight;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getBodyweightMeasure() {
		return bodyweightMeasure;
	}

	public void setBodyweightMeasure(String bodyweightMeasure) {
		this.bodyweightMeasure = bodyweightMeasure;
	}

	public Date getReading() {
		return reading;
	}

	public void setReading(Date reading) {
		this.reading = reading;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}


}
