package gov.va.med.mhv.vitals.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
@Entity
@Table(name="BLOOD_SUGAR_READINGS")
public class BloodSugarReading implements Serializable{
	
	private static final long serialVersionUID = 8011073710136368897L;
    
	  
    @Id
	@Column(name="BLOOD_SUGAR_ID_SEQ")
	@GeneratedValue(strategy=GenerationType.AUTO) 
    private Long id;
    
	@Column(name="OPLOCK")
	private Integer oplock;
	
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="TESTING_METHOD")
    private String testingMethod;
	
	@Column(name="BLOOD_SUGAR_COUNT")
    private Integer bloodSugarCount;
	
	@Column(name="READING")
	@Temporal(TemporalType.TIMESTAMP)
	private Date reading;

	
	@Column(name="USER_PROFILE_USER_PROFILE_ID")
	private Long userprofileId;


	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}


	public Integer getOplock() {
		return oplock;
	}


	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}


	public String getComments() {
		return comments;
	}


	public void setComments(String comments) {
		this.comments = comments;
	}


	public String getTestingMethod() {
		return testingMethod;
	}


	public void setTestingMethod(String testingMethod) {
		this.testingMethod = testingMethod;
	}


	public Integer getBloodSugarCount() {
		return bloodSugarCount;
	}


	public void setBloodSugarCount(Integer bloodSugarCount) {
		this.bloodSugarCount = bloodSugarCount;
	}


	public Date getReading() {
		return reading;
	}


	public void setReading(Date reading) {
		this.reading = reading;
	}


	public Long getUserprofileId() {
		return userprofileId;
	}


	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

 

	
	

	

}
