package gov.va.med.mhv.vitals.dto;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.med.mhv.vitals.enums.WeightMeasureEnumeration;

@XmlRootElement(name = "BodyWeightReadingDTO")
public class BodyWeightReadingDTO extends AbstractDTO implements Serializable{
	
	private static final long serialVersionUID = 1002980247076801410L;
	
	private Long bodyweightID;
	private BigDecimal bodyweight;
	private String comments;
	private Long userprofileId;
	
	@JsonIgnore
	private WeightMeasureEnumeration weightMeasure = WeightMeasureEnumeration.P;
	
	public Long getBodyweightID() {
		return bodyweightID;
	}
	public void setBodyweightID(Long bodyweightID) {
		this.bodyweightID = bodyweightID;
	}
	public BigDecimal getBodyweight() {
		return bodyweight;
	}
	public void setBodyweight(BigDecimal bodyweight) {
		this.bodyweight = bodyweight;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public String getBodyweightMeasure() {
		return this.weightMeasure.toString();
	}
	public void setBodyweightMeasure(String bodyweightMeasure) {
		this.weightMeasure = WeightMeasureEnumeration.valueOf(bodyweightMeasure);
	}
	@JsonIgnore
	public String getDisplayBodyWeightMeasure() {
		return this.weightMeasure.getDescription();
	}
	public Long getUserprofileId() {
		return userprofileId;
	}
	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}
	public WeightMeasureEnumeration getWeightMeasure() {
		return weightMeasure;
	}
	@JsonIgnore
	public WeightMeasureEnumeration[] getWeightMeasures() {
		return WeightMeasureEnumeration.values();
	}

}
