package gov.va.med.mhv.vitals.dto;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.med.mhv.vitals.enums.BloodSugarTestingMethodEnumeration;

@XmlRootElement(name = "BloodSugarReadingDTO")
public class BloodSugarReadingDTO extends AbstractDTO implements Serializable{

    private static final long serialVersionUID = 5623491499231403705L;
  
    private Long bloodSugarId;
    private String comments;
    private BloodSugarTestingMethodEnumeration testingMethod = BloodSugarTestingMethodEnumeration.CLT;
    private Integer bloodSugarCount;
    private Long userprofileId;
    
	public Long getBloodSugarId() {
		return bloodSugarId;
	}
	public void setBloodSugarId(Long bloodSugarId) {
		this.bloodSugarId = bloodSugarId;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public String getTestingMethod() {
		return testingMethod.name();
	}
	@JsonIgnore
	public String getDisplayTestingMethod() {
		return this.testingMethod.getDescription();
	}
	public void setTestingMethod(String testingMethod) {
		this.testingMethod = BloodSugarTestingMethodEnumeration.valueOf(testingMethod);
	}
	public Integer getBloodSugarCount() {
		return bloodSugarCount;
	}
	public void setBloodSugarCount(Integer bloodSugarCount) {
		this.bloodSugarCount = bloodSugarCount;
	}
	public Long getUserprofileId() {
		return userprofileId;
	}
	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

	@JsonIgnore
	public BloodSugarTestingMethodEnumeration[] getTestMethods() {
		return BloodSugarTestingMethodEnumeration.values();
	}

}
