package gov.va.med.mhv.vitals.dto;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.med.mhv.vitals.enums.HourEnumeration;
import gov.va.med.mhv.vitals.enums.MinuteEnumeration;
import gov.va.med.mhv.vitals.util.CommonUtility;

public class AbstractDTO {
	
	private String dateEntered;
	private String timeEntered;
	private String hour;
	private String minute;
	//common attribute shared by all DTOS
	private Date reading;
	
	private String dashboardDate;
	
	public String getDateEntered() {
		return  CommonUtility.dateToString(getReading(), "MM/dd/yyyy");
	}

	public void setDateEntered(String dateEntered) {
		this.dateEntered = dateEntered;
	}

	public String getTimeEntered() {
		String time = CommonUtility.dateToString(getReading(), "HH:mm");
		if(time.equals("23:59")){
			time=null;
		}
		return time;
	}

	public void setTimeEntered(String timeEntered) {
		this.timeEntered = timeEntered;
	}

	public String getHour() {
		return hour;
	}

	public void setHour(String hour) {
		this.hour = hour;
	}

	public String getMinute() {
		return minute;
	}

	public void setMinute(String minute) {
		this.minute = minute;
	}
	
	@JsonIgnore
	public HourEnumeration[] getHours() {
		return HourEnumeration.values();
	}
	
	@JsonIgnore
	public MinuteEnumeration[] getMinutes() {
		return MinuteEnumeration.values();
	}

	/**
	 * @return the reading
	 */
	public Date getReading() {
		return reading;
	}

	/**
	 * @param reading the reading to set
	 */
	public void setReading(Date reading) {
		this.reading = reading;
	}
	

	public String getDashboardDate() {
		return  CommonUtility.dateToString(getReading(), "EEE MM/dd/yyyy");
	}

	public void setDashboardDate(String dashboardDate) {
		this.dashboardDate = dashboardDate;
	}
	

}
