package gov.va.med.mhv.usermgmt.jms;
import java.util.List;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;

/**
 * @author DNS   egberb
 *
 */
@Component
public class JmsAccountActivityCreatorImpl implements AccountActivityCreatorService {
	
	private static Logger LOGGER = LogManager.getLogger(JmsAccountActivityCreatorImpl.class);
	
	@Autowired
	private AccountActivityCreatorService accountActivityCreator;

	@JmsListener(destination = "jms/usermgmt/ACCOUNT_ACTIVITY_Q", containerFactory = "jmsListenerContainerFactory")
	@Override
	public void createAccountActivityLog(ActivityDTO activity) throws MHVException {
		
		try {
			this.accountActivityCreator.createAccountActivityLog(activity);
		} catch (Exception ex) {
			String message = "Error creating Account Activity entry.";
			LOGGER.error(message);
			throw new MHVException(message, ex);
		}
	}

//	@JmsListener(destination = "jms/usermgmt/ACCOUNT_ACTIVITY_Q", containerFactory = "jmsListenerContainerFactory")
//	@Override
//	public void createAccountActivityLogByList(List<ActivityDTO> activityDTOs)
//			throws MHVException {
//		try {
//			this.accountActivityCreator.createAccountActivityLogByList(activityDTOs);
//		} catch (Exception ex) {
//			String message = "Error creating Account Activity entry.";
//			LOGGER.error(message);
//			throw new MHVException(message, ex);
//		}
//		
//	}

}
