package gov.va.med.mhv.usermgmt.web.util;

import java.io.Serializable;
import java.util.regex.Pattern;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.stereotype.Component;

import com.fortify.annotations.FortifyNotPassword;

@ManagedBean
@Component
public class WebValidator implements Serializable {

	private static Logger log = LogManager.getLogger(WebValidator.class);
	/**
	 * 
	 */
	private static final long serialVersionUID = -390029229129088245L;
	private static final String NAME_PATTERN = "^[A-Za-z]+$";
	private static final String EMAIL_PATTERN ="^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
	
	//TODO: Fix me - Prasad
	//@Value("${confirmNewPassword}")
	private  @FortifyNotPassword String confirmNewPassword = "confirmNewPassword";
	
	//TODO: Fix me - Prasad
	//@Value("${passwdsNotEqualErrMessage}")
	private @FortifyNotPassword String passwdsNotEqualErrMessage = "The specified passwords do not match.";
	
	public WebValidator(){
		
	}

	public void validateName(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		validateRegExpression(context,component,value,NAME_PATTERN);
	}
	
	public void validateEmail(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		validateRegExpression(context,component,value,EMAIL_PATTERN);
	}
	
	private void validateRegExpression(FacesContext context, UIComponent component, Object value,String regex){
		String inputValue =(String)value;
		Pattern pattern= Pattern.compile(regex);
		if(!pattern.matcher(inputValue).matches()){
			String controlName=(String)component.getAttributes().get("title");
			String msg= controlName + " is invalid";
			
			//TODO : Remove this commented block after testing  get rid of duplicate error messages
			// FacesContext.getCurrentInstance().addMessage(null,
   			//	  new FacesMessage(FacesMessage.SEVERITY_ERROR,msg,msg));
   		
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
		}
	}
	

	public void validate(FacesContext context, UIComponent component, Object value)
        throws ValidatorException
    {
    	if (log.isInfoEnabled()) {
    		log.info("inside validate() confirmNewPassword: " + confirmNewPassword + " passwdsNotEqualErrMessage : " + passwdsNotEqualErrMessage);
    	}
        // Cast the value of the entered password to String.
        String newPassword = (String) value;

        // Obtain the component and submitted value of the confirm password component.
        UIInput confirmComponent = (UIInput) component.getAttributes().get(confirmNewPassword);
        String confirmNewPassword = (String) confirmComponent.getSubmittedValue();
        

        // Check if they both are filled in.
        if (newPassword == null || newPassword.isEmpty() || confirmNewPassword == null || confirmNewPassword.isEmpty()) {
            return; // Let required="true" do its job.
        }

        // Compare the password with the confirm password.
        if (!newPassword.equals(confirmNewPassword)) {
        	confirmComponent.setValid(false); // So that it's marked invalid.
            throw new ValidatorException(new FacesMessage(passwdsNotEqualErrMessage));
        }
    }
	
	
	@Bean
	public static PropertySourcesPlaceholderConfigurer propertyPlaceholderConfigurer() {
	    return new PropertySourcesPlaceholderConfigurer();
	}
}
