package gov.va.med.mhv.usermgmt.web.util;

import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import javax.portlet.PortletRequest;

import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

public class RoleTagHandler extends TagHandler{
	//private String roles;
	
	
	public RoleTagHandler(TagConfig config){
		super(config);
	}

	@Override
	public void apply(FaceletContext ctx, UIComponent parent)
			throws IOException {
		
		try{
			 PortletRequest   request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
			 //User user =PortalUtil.getUser(request);
			 //List<Role> liferayRoles =user.getRoles();
			 if(request.getUserPrincipal() != null){
				 TagAttribute attr = getAttribute("roles");
				 if(attr == null){
					 throw new RuntimeException("attribute roles is mandatory");
				 }
				 String roles = attr.getValue();
				 StringTokenizer st = new StringTokenizer(roles,"\t\n\r\f,");
				 boolean roleFound = false;
				 while(st.hasMoreElements()){
					String role = (String)st.nextElement();
					if(request.isUserInRole(role)){
						roleFound=true;
						break;
					}
				 }
				 if(roleFound){
					 this.nextHandler.apply(ctx, parent);
				 }
			 }
			 
		 }catch(Exception e){
			 e.printStackTrace();
		 }
	}
}
