package gov.va.med.mhv.usermgmt.web.util;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.stereotype.Component;

import com.fortify.annotations.FortifyNotPassword;

/**
 * @author DNS   THUMMP
 * 
 */
@Component
@Scope("request")
//@PropertySource("classpath:application.properties")
/*
 * TODO: THIS CLASS MIGHT NOT BE REQUIRED,
 * validations could be done in service validator class
 */
public class PasswordValidator implements Validator {

	private static Logger log = LogManager.getLogger(PasswordValidator.class);
	
	//@Value("${confirmNewPassword}")
	private @FortifyNotPassword String confirmNewPassword = "confirmNewPassword";
	
	//@Value("${passwdsNotEqualErrMessage}")
	private @FortifyNotPassword String passwdsNotEqualErrMessage = "The specified passwords do not match.";
	

	public void validate(FacesContext context, UIComponent component, Object value)
        throws ValidatorException
    {
    	if (log.isInfoEnabled()) {
    		log.info("inside validate() confirmNewPassword: " + confirmNewPassword + " passwdsNotEqualErrMessage : " + passwdsNotEqualErrMessage);
    	}
        // Cast the value of the entered password to String.
        String newPassword = (String) value;

        // Obtain the component and submitted value of the confirm password component.
        UIInput confirmComponent = (UIInput) component.getAttributes().get(confirmNewPassword);
        String confirmNewPassword = (String) confirmComponent.getSubmittedValue();

        
        // Check if they both are filled in.
        if (newPassword == null || newPassword.isEmpty() || confirmNewPassword == null || confirmNewPassword.isEmpty()) {
            return; // Let required="true" do its job.
        }

        // Compare the password with the confirm password.
        if (!newPassword.equals(confirmNewPassword)) {
        	confirmComponent.setValid(false); // So that it's marked invalid.
            throw new ValidatorException(new FacesMessage(passwdsNotEqualErrMessage));
        }
    }
	
	@Bean
	public static PropertySourcesPlaceholderConfigurer propertyPlaceholderConfigurer() {
	    return new PropertySourcesPlaceholderConfigurer();
	}
}	
