package gov.va.med.mhv.usermgmt.web.formbean;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

/**
 * Utility managed bean that can be used to get information about current user
 * Intended to be used in controllers and xhtml pages 
 */
@ManagedBean
@SessionScoped
public class UserProfileSession implements Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(UserProfileSession.class);

	public String getFirstName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {
			log.warn("unknown user");
		}

		return (user != null ? user.getFirstName() : "???");
	}

	public String getLastName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		try {
			user = PortalUtil.getUser(request);
		} catch (Exception e) {
			log.warn("unknown user");
		}

		return (user != null ? user.getLastName() : "???");
	}

	public String getFullName() {
		return getFirstName() + " " + getLastName();
	}

	public String getAccountType() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();

		String accountType = (String) session.getAttribute("LIFERAY_SHARED_accountType", PortletSession.APPLICATION_SCOPE);

		return accountType;
	}

	public Long getUserProfileId() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();

		Long userProfileId = (Long) session.getAttribute("LIFERAY_SHARED_userprofileid", PortletSession.APPLICATION_SCOPE);
		
		return userProfileId;
	}

}