package gov.va.med.mhv.usermgmt.web.formbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.usermgmt.common.enums.BloodTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ContactMethodEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.CountryEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.GenderEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.MaritalStatusEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.MonthDayEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.MonthEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PasswordHintQuestionsEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.StateEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.SuffixEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.TitleEnumeration;
import gov.va.med.mhv.usermgmt.web.util.WebUtility;

public class UserProfile extends UserProfileDTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -9140505569372788358L;

	private static final int BIRTH_DT_START_YEAR = 1895;

	private String ssnThree;
	private String ssnTwo;
	private String ssnFour;
	private String ssnCnfThree;
	private String ssnCnfTwo;
	private String ssnCnfFour;
	private Integer birthMonth;
	private Integer birthDay;
	private Integer birthYear;
	// using below date place holder by registration
	private Integer bMonth;
	private Integer bDay;
	private Integer bYear;
	private String ssn3;
	private String ssn2;
	private String ssn4;
	private String confSsn3;
	private String confSsn2;
	private String confSsn4;
	private boolean dispMiddleName;
	private String birthMonthDisplay;
	private String birthDayDisplay;

	public UserProfile() {
		super.setRxTrackingEmailPref(false);
		super.setApptReminderEmailPref(false);
		super.setHealthSummarySentEmailPref(false);
		this.setDispMiddleName(true);
	}

	public String getSsnThree() {
		ssnThree = null;
		if (getSsn() != null && getSsn().trim().length() > 0) {
			ssnThree = getSsn().substring(0, 3);
		}
		return ssnThree;
	}

	public void setSsnThree(String ssnThree) {
		this.ssnThree = ssnThree;
		this.ssn3=ssnThree;
	}

	public String getSsnTwo() {
		ssnTwo = null;
		if (getSsn() != null && getSsn().trim().length() > 0) {
			ssnTwo = getSsn().substring(4, 6);
		}
		return ssnTwo;
	}

	public void setSsnTwo(String ssnTwo) {
		this.ssnTwo = ssnTwo;
		this.ssn2=ssnTwo;
	}

	public String getSsnFour() {
		ssnFour = null;
		if (getSsn() != null && getSsn().trim().length() > 0) {
			ssnFour = getSsn().substring(7, 11);
		}
		return ssnFour;
	}

	public void setSsnFour(String ssnFour) {
		this.ssnFour = ssnFour;
		this.ssn4=ssnFour;
	}

	public String getSsnCnfThree() {
		ssnCnfThree = null;
		if (getSsn() != null && getSsn().trim().length() > 0) {
			ssnCnfThree = getSsn().substring(0, 3);
		}
		return ssnCnfThree;
	}

	public void setSsnCnfThree(String ssnCnfThree) {
		this.ssnCnfThree = ssnCnfThree;
		this.confSsn3=ssnCnfThree;
	}

	public String getSsnCnfTwo() {
		ssnCnfTwo = null;
		if (getSsn() != null && getSsn().trim().length() > 0) {
			ssnCnfTwo = getSsn().substring(4, 6);
		}
		return ssnCnfTwo;
	}

	public void setSsnCnfTwo(String ssnCnfTwo) {
		this.ssnCnfTwo = ssnCnfTwo;
		this.confSsn2=ssnCnfTwo;
		
	}

	public String getSsnCnfFour() {
		ssnCnfFour = null;
		if (getSsn() != null && getSsn().trim().length() > 0) {
			ssnCnfFour = getSsn().substring(7, 11);
		}
		return ssnCnfFour;
	}

	public void setSsnCnfFour(String ssnCnfFour) {
		this.ssnCnfFour = ssnCnfFour;
		this.confSsn4=ssnCnfFour;
	}
	
	
	public Integer getBirthMonth() {
		Integer monthInt = null;
		String monthString=WebUtility.dateToString(getBirthDate(), "MM");
		if(monthString != null && monthString.trim().length() > 0){
			monthInt = Integer.parseInt(monthString);
		}
		return monthInt;
	}

	public void setBirthMonth(Integer birthMonth) {
		this.birthMonth = birthMonth;
		this.bMonth=Integer.valueOf(birthMonth) ;
	}
	
	

	public Integer getBirthDay() {
		Integer dayInt = null;
		String dayString=WebUtility.dateToString(getBirthDate(), "dd");
		if(dayString != null && dayString.trim().length() > 0){
			dayInt = Integer.parseInt(dayString);
		}
		return dayInt;
	}

	public void setBirthDay(Integer birthDay) {
		this.birthDay = birthDay;
		this.bDay= Integer.valueOf(birthDay);
		
	}


	public Integer getBirthYear() {
		Integer yearInt = null;
		String yearString=WebUtility.dateToString(getBirthDate(), "yyyy");
		if(yearString != null && yearString.trim().length() > 0){
			yearInt = Integer.parseInt(yearString);
		}
		return yearInt;
	}

	public void setBirthYear(Integer birthYear) {
		this.birthYear = birthYear;
		this.bYear=Integer.valueOf(birthYear);
	}
	
	public Integer getbMonth() {
		return bMonth;
	}

	public void setbMonth(Integer bMonth) {
		this.bMonth = bMonth;
	}

	public Integer getbDay() {
		return bDay;
	}

	public void setbDay(Integer bDay) {
		this.bDay = bDay;
	}

	public Integer getbYear() {
		return bYear;
	}

	public void setbYear(Integer bYear) {
		this.bYear = bYear;
	}

	public String getSsn3() {
		return ssn3;
	}

	public void setSsn3(String ssn3) {
		this.ssn3 = ssn3;
	}

	public String getSsn2() {
		return ssn2;
	}

	public void setSsn2(String ssn2) {
		this.ssn2 = ssn2;
	}

	public String getSsn4() {
		return ssn4;
	}

	public void setSsn4(String ssn4) {
		this.ssn4 = ssn4;
	}

	public String getConfSsn3() {
		return confSsn3;
	}

	public void setConfSsn3(String confSsn3) {
		this.confSsn3 = confSsn3;
	}

	public String getConfSsn2() {
		return confSsn2;
	}

	public void setConfSsn2(String confSsn2) {
		this.confSsn2 = confSsn2;
	}

	public String getConfSsn4() {
		return confSsn4;
	}

	public void setConfSsn4(String confSsn4) {
		this.confSsn4 = confSsn4;
	}
	
	public boolean isDispMiddleName() {
		return dispMiddleName;
	}
	
	public void setDispMiddleName(boolean dispMiddleName) {
		this.dispMiddleName = dispMiddleName;
	}

	public TitleEnumeration[] getTitles() {
		return TitleEnumeration.values();
	}

	public SuffixEnumeration[] getSuffixes() {
		return SuffixEnumeration.values();
	}

	public GenderEnumeration[] getGenders() {
		return GenderEnumeration.values();
	}

	public MaritalStatusEnumeration[] getMaritalStatuses() {
		return MaritalStatusEnumeration.values();
	}

	public BloodTypeEnumeration[] getBloodTypes() {
		return BloodTypeEnumeration.values();
	}

	public CountryEnumeration[] getCountries() {
		return CountryEnumeration.values();
	}

	public StateEnumeration[] getStates() {
		return StateEnumeration.values();
	}

	public ContactMethodEnumeration[] getContactMethods() {
		return ContactMethodEnumeration.values();
	}

	public PasswordHintQuestionsEnumeration[] getQuestions() {
		return PasswordHintQuestionsEnumeration.values();
	}

	public List<String> getYears() {
		List<String> yearList = new ArrayList<String>();
		int endYear = Calendar.getInstance().get(Calendar.YEAR);

		for (int i = BIRTH_DT_START_YEAR; i <= endYear; i++) {
			yearList.add(String.valueOf(i));
		}
		return yearList;
	}

	public MonthEnumeration[] getMonths() {
		return MonthEnumeration.values();
	}

	public MonthDayEnumeration[] getMonthDays() {
		return MonthDayEnumeration.values();
	}

	public String getBirthMonthDisplay() {
		return 	WebUtility.dateToString(getBirthDate(), "MMM");

	}

	public void setBirthMonthDisplay(String birthMonthDisplay) {
		this.birthMonthDisplay = birthMonthDisplay;
	}

	public String getBirthDayDisplay() {
		return 	WebUtility.dateToString(getBirthDate(), "dd");
	}

	public void setBirthDayDisplay(String birthDayDisplay) {
		this.birthDayDisplay = birthDayDisplay;
	}

}
