/**
 * 
 */
package gov.va.med.mhv.usermgmt.web.controller;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;


import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import com.liferay.portal.util.PortalUtil;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.CommonUtility;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PasswordHintQuestionsEnumeration;
import gov.va.med.mhv.usermgmt.web.exception.MHVRuntimeException;
import gov.va.med.mhv.usermgmt.web.formbean.ForgotUserName;

/**
 * @author DNS   silver
 * 
 */
@ManagedBean
@Component
@Scope(WebApplicationContext.SCOPE_SESSION)
public class ForgotUserController extends AbstractController implements
		Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -9191875686222494443L;
	
	private static Logger logger = LogManager.getLogger(ForgotUserController.class);

	private static String STEP_1 = "STEP_1";
	private static String STEP_2 = "STEP_2";
	private static String STEP_3 = "STEP_3";
	
	private String currentStep = STEP_1;
	
	@Autowired
	private ForgotUserName forgotUserName;
//	private ChangePassword changePassword;

	public ForgotUserName getForgotUserName() {
		return forgotUserName;
	}

	public void setForgotUserName(ForgotUserName forgotUserName) {
		this.forgotUserName = forgotUserName;
	}

	private UserProfileDTO userProfile = null;
	
	private String userName;
	
	public void viewControl() {
		javax.portlet.RenderRequest request = (javax.portlet.RenderRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();

		HttpServletRequest httpReq = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(request));
		String action = httpReq.getParameter("action");

		if( "new".equals(action) ) {
			this.currentStep = STEP_1;
			this.forgotUserName = new ForgotUserName();
		} 
	}

	
	public String step1Action() {
		logger.debug("ForgotUserController.step1Action");

		logger.info("========inside step1Action()============ ");

//		PortletRequest request = (PortletRequest) FacesContext
//				.getCurrentInstance().getExternalContext().getRequeft();
//
//		PortletSession session = request.getPortletSession();

		logger.debug("ForgotUserController - step1Action");

		int day = Integer.parseInt(forgotUserName.getDay());  
		int month = Integer.parseInt(forgotUserName.getMonth()); 
		int year = Integer.parseInt(forgotUserName.getYear()); 
		Calendar c = Calendar.getInstance();
		c.set(year, month-1, day, 0, 0);  
		String dateStr = month + "/" + day + "/" + year;
		//Date birthDate = c.getTime();
		Date birthDate = CommonUtility.stringToDate(dateStr, "MM/dd/yyyy");
		userProfile = new UserProfileDTO();

		String firstName = forgotUserName.getFirstName();
		if( firstName == null || firstName.length() == 0 ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"First name is a required field.", "General error."));
		}
		userProfile.setFirstName(firstName);

		String lastName = forgotUserName.getLastName();
		if( lastName == null || lastName.length() == 0 ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"Last name is a required field.", "General error."));
		}

		if( FacesContext.getCurrentInstance().getMessageList().size() > 0 ) {
			return "";
		}

		userProfile.setLastName(forgotUserName.getLastName());

		userProfile.setGender(forgotUserName.getGender());
		userProfile.setBirthDate(birthDate);
		
		try {
			
			userProfile = this.accountValidatorService.getUserProfile(userProfile.getFirstName(), userProfile.getLastName(), userProfile.getGender(), userProfile.getBirthDate());
   
			currentStep = STEP_2;
			logger.debug("ChangePasswordController - success");

			int q1 = userProfile.getPasswordHintQuestion1();
			int q2 = userProfile.getPasswordHintQuestion2();
			for (PasswordHintQuestionsEnumeration s : PasswordHintQuestionsEnumeration.values()) {
				if (s.getValue() == q1) {
					forgotUserName.setQuestion1(s.getDescription());
				}
				if (s.getValue() == q2) {
					forgotUserName.setQuestion2(s.getDescription());
				}
			}

		} catch (Exception e) {
			currentStep = STEP_1;
		logger.debug("ForgotUserController - Get Profile - fail");
		
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"A user could not be found with the specified profile.", "General error."));
		logger.debug("ForgotUserController - exception "
				+ e.getMessage());
			
		}
		return "";
	}

	public String step2Action() {
		try {
			this.accountValidatorService.validateHintAnswers(userProfile.getId(), forgotUserName.getAnswer1(), forgotUserName.getAnswer2());
			userName = userProfile.getUserName();
			currentStep = STEP_3;
			this.forgotUserName = new ForgotUserName();
			return "";
		} catch (MHVException e) {

			boolean existsValidationError = false;
			boolean existsFailureMessage = false;

			// add validation errors to portlet
			Map<String, String> map = e.getValidationErrorMessages();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (logger.isDebugEnabled()) {
					if (null != entry) {
						logger.debug("entry.getKey() : " + entry.getKey());
						logger.debug("entry.getValue() : " + entry.getValue());
					}
				}
				existsValidationError = true;
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}

			// check for non-validation errors in response object
			if (!existsValidationError && null != e.getFailureMessage() && e.getFailureMessage().length() > 0) {
				String errorMessage = e.getFailureMessage();

				if (logger.isDebugEnabled()) {
					logger.debug("FailureMessage : " + e.getFailureMessage());
				}

				// TODO: Fix Error message
				existsFailureMessage = true;
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, errorMessage));
			}

			// add info errors to portlet
			Map<String, String> infoMessages = e.getInfoMessages();
			int infoSize = (infoMessages != null && infoMessages.size() > 0) ? infoMessages.size() : 0;
			logger.debug("infoSize : " + infoSize);
			if (!existsValidationError && !existsFailureMessage && infoSize > 0) {
				for (String infoMessage : infoMessages.values()) {
					logger.debug("infoMessage : " + infoMessage);
					FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, infoMessage, null));
				}
			}

		} catch (Exception e) {
			logger.error("Error in Save user profile:", e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Error Validating Hint Answers", null));
		}
		
		return null;
		
	}
	

	public String getCurrentStep() {
		return currentStep;
	}

	public void setCurrentStep(String currentStep) {
		this.currentStep = currentStep;
	}

	public String getUserName() {
		currentStep = STEP_1;
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

}