package gov.va.med.mhv.usermgmt.web.controller;

import java.io.IOException;
import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.EauthHashDTO;
import gov.va.med.mhv.usermgmt.web.exception.MHVRuntimeException;

@ManagedBean
@Component
@Scope("session")
public class DisconnectAccountController extends AbstractController{
		
	private static final long serialVersionUID = 1167992013831097888L;
	private static Logger log = LogManager.getLogger(DisconnectAccountController.class);
	private boolean showMain=false;
	private boolean noAccount=false;
	private boolean confirm=false;
	private boolean disconnected=false;
	private Long userprofileId;
	
	public DisconnectAccountController(){
		
	}
	
	/**
	 *  Based on if the user has accounts or not the relevant part of the page is shown.
	 */
	public void init(ComponentSystemEvent event){
		FacesContext context = FacesContext.getCurrentInstance();
		if (!context.isPostback()){
			initPageSections();
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			PortletSession session = request.getPortletSession();
			Object profileId = session.getAttribute("LIFERAY_SHARED_userprofileid", PortletSession.APPLICATION_SCOPE);
			if(profileId != null){
				userprofileId = (Long)profileId;
				List<EauthHashDTO> eauthHashDTOS =getEauthHashesForuserprofile(userprofileId);
				if(eauthHashDTOS != null && eauthHashDTOS.size() > 0){
					showMain=true;
				}else{
					log.debug("The user has no accounts to disconnect");
					
					noAccount=true;
				}
			}else{
				log.debug("The user has no MHV Account");
				
				noAccount=true;
			}
		}
	}
	
	//initialize the flags that are used to display different parts of the page
	private void initPageSections() {
		showMain=false;
		noAccount=false;
		confirm=false;
		disconnected=false;
	}

	private List<EauthHashDTO> getEauthHashesForuserprofile(Long userprofileId) {
		List<EauthHashDTO>  eauthDTOS=null;
		try {
			eauthDTOS = this.userMgmtService.findEAuthHashByUserProfileId(userprofileId);
		} catch (MHVException e) {
			log.error("Error in getting EauthHashes:",e);
		}
		return eauthDTOS;
	}

	public String confirmSubmit(){
		initPageSections();
		confirm=true;
		return null;
	}
	
	public String confirmCancel(){
		try {
			FacesContext.getCurrentInstance().getExternalContext().
			             redirect(getAppContextRoot()+"personal-information");
		} catch (IOException e) {
			log.error("Error Confirm cancel:", e);
			throw new MHVRuntimeException(e);
		}
		return null;
	}
	
	public String disconnect(){
		try {
			this.userMgmtService.deleteEauthHashByUserProfileId(userprofileId);
			initPageSections();
			disconnected=true;
		} catch (Exception e) {
			log.error("Error in Disconnecting accounts:",e);
		    confirm=true;
			FacesContext.getCurrentInstance().
			addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error processing your request", "Error  processing your request"));
		}
		return null;
	}
	
	public String cancelDisconnect(){
		initPageSections();
		showMain=true;
		return null;
	}
	

	public boolean getShowMain() {
		return showMain;
	}

	public void setShowMain(boolean showMain) {
		this.showMain = showMain;
	}


	public boolean isNoAccount() {
		return noAccount;
	}


	public void setNoAccount(boolean noAccount) {
		this.noAccount = noAccount;
	}


	public boolean isConfirm() {
		return confirm;
	}


	public void setConfirm(boolean confirm) {
		this.confirm = confirm;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

	public boolean isDisconnected() {
		return disconnected;
	}

	public void setDisconnected(boolean disconnected) {
		this.disconnected = disconnected;
	}

}
