package gov.va.med.mhv.usermgmt.web.controller;

import java.io.Serializable;

import javax.faces.bean.ManagedBean;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.liferay.portal.kernel.util.PropsUtil;

@ManagedBean
@Component
@Scope("session")
@PropertySources(value = {
	@PropertySource("classpath:/${MHV_ENV_PROPERTY}.usermgmt.liferay.properties"), 
	@PropertySource("classpath:/${MHV_ENV_PROPERTY}.usermgmt.properties")
})
public class ContactUsController implements Serializable {

	private static final long serialVersionUID = -7727481596389861759L;
	private static Logger log = LogManager.getLogger(ContactUsController.class);
	
	@Value("${contactus.irisServerAddress}")
	private String contactusIrisServerAddress;
	
	public void setContactusIrisServerAddress(String contactusIrisServerAddress) {
		this.contactusIrisServerAddress = contactusIrisServerAddress;
	}
	
	public String getContactusIrisServerAddress() {
		return contactusIrisServerAddress;
	}
	
	public String getMhvContext(){
		String context = PropsUtil.get("mhv.context");
		
		if (log.isDebugEnabled()) {
			log.debug("context " + context);
		}
		
		return context;
    }
}
