package gov.va.med.mhv.usermgmt.web.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import com.liferay.portal.util.PortalUtil;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.usermgmt.web.converter.CareGiverConverter;
import gov.va.med.mhv.usermgmt.web.exception.MHVRuntimeException;
import gov.va.med.mhv.usermgmt.web.formbean.CareGiver;

@ManagedBean
@Component
@Scope(WebApplicationContext.SCOPE_SESSION)
/**
 * Controller class to support the Care Giver Flow Extends the
 * AbstactListController class that provides pagination functionality.
 * 
 * @author DNS   SILVER
 *
 */
public class CareGiverController extends AbstractListController<CareGiver> implements Serializable {

	private static final long serialVersionUID = 8611310131485455448L;

	private static Logger logger = LogManager.getLogger(CareGiverController.class);

	private CareGiver careGiver;

	private CareGiverConverter converter = new CareGiverConverter();

	private DataTable careGiverDataTable;

	private String viewMode = VM_SHORT_LIST;

	protected List<CareGiver> viewShortList = null;

	public List<CareGiver> getViewShortList() {
		viewShortList = new ArrayList<CareGiver>();

		if (viewList != null && viewList.size() > 0) {
			// loop the view list and get the first of each type.
			// Primary, Specialist, Dentist, Eye, Other Clinician
			boolean p = false;
			boolean s = false;
			boolean d = false;
			boolean e = false;
			boolean o = false;
			for (CareGiver c : this.viewList) {
				if ("Primary".equals(c.getProviderType()) && p == false) {
					p = true;
					viewShortList.add(c);
				}
				if ("Specialist".equals(c.getProviderType()) && s == false) {
					s = true;
					viewShortList.add(c);
				}
				if ("Dentist".equals(c.getProviderType()) && d == false) {
					d = true;
					viewShortList.add(c);
				}
				if ("Eye".equals(c.getProviderType()) && e == false) {
					e = true;
					viewShortList.add(c);
				}
				if ("Other Clinician".equals(c.getProviderType()) && o == false) {
					o = true;
					viewShortList.add(c);
				}
				if (p & s & d & e & o) {
					break;
				}
			}
		}
		return viewShortList;
	}

	public CareGiver getCareGiver() {
		return careGiver;
	}

	public void setCareGiver(CareGiver careGiver) {
		this.careGiver = careGiver;
	}

	public CareGiverConverter getConverter() {
		return converter;
	}

	public void setConverter(CareGiverConverter converter) {
		this.converter = converter;
	}

	public DataTable getCareGiverDataTable() {
		return careGiverDataTable;
	}

	public void setCareGiverDataTable(DataTable careGiverDataTable) {
		this.careGiverDataTable = careGiverDataTable;
	}

	public String getViewMode() {
		this.viewControl();
		return viewMode;
	}

	private static String VM_SHORT_LIST = "VM_SHORT_LIST";
	private static String VM_LONG_LIST = "VM_LONG_LIST";
	private static String VM_VIEW_CARE_GIVER = "VM_VIEW_CARE_GIVER";
	private static String VM_EDIT_CARE_GIVER = "VM_EDIT_CARE_GIVER";
	private static String VM_EDIT_DELETE_CARE_GIVER = "VM_EDIT_DELETE_CARE_GIVER";

	public void viewControl() {
		Object o = FacesContext.getCurrentInstance().getExternalContext().getRequest();
		HttpServletRequest httpReq = null;
		if (o instanceof javax.portlet.RenderRequest) {
			javax.portlet.RenderRequest request = (javax.portlet.RenderRequest) o;
			httpReq = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(request));
		} else if (o instanceof javax.portlet.ResourceRequest) {
			javax.portlet.ResourceRequest request = (javax.portlet.ResourceRequest) o;
			httpReq = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(request));
		} else if (o instanceof javax.portlet.ActionRequest) {
			javax.portlet.ActionRequest request = (javax.portlet.ActionRequest) o;
			httpReq = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(request));
		}

		if(httpReq != null) {
			String action = httpReq.getParameter("action");
	
			if ("delete".equals(action)) {
				String cgId = httpReq.getParameter("cg");
				CareGiver cg = findById(cgId);
				this.viewMode = VM_EDIT_DELETE_CARE_GIVER;
				if (cg != null)
					this.careGiver = cg;
			} else if ("add".equals(action)) {
				this.viewMode = VM_EDIT_CARE_GIVER;
				this.careGiver = new CareGiver();
				this.careGiver.setUserProfileId(userProfile.getId());
			} else if ("edit".equals(action)) {
				String cgId = httpReq.getParameter("cg");
				this.viewMode = VM_EDIT_CARE_GIVER;
				this.careGiver = new CareGiver();
				this.careGiver.setUserProfileId(userProfile.getId());
	
				CareGiver cg = findById(cgId);
				if (cg != null)
					this.careGiver = cg;
			} else if ("long".equals(action)) {
				this.viewMode = VM_LONG_LIST;
			} else if ("short".equals(action)) {
				this.viewMode = VM_SHORT_LIST;
			}
		}
	}

	private CareGiver findById(String id) {
		if (id == null)
			return null;

		Long cgId = new Long(id);
		CareGiver cg = null;

		if (modelList != null && modelList.size() > 0) {
			for (CareGiver c : modelList) {
				if (c.getCareGiverId().longValue() == cgId.longValue()) {
					cg = c;
					break;
				}
			}
		}
		return cg;
	}

	public String editCareGiverAction() {
		logger.debug("CareGiverController - editCareGiverAction");
		CareGiver cg = (CareGiver) careGiverDataTable.getRowData();
		return editCareGiver(cg);
	}

	public String editFromViewCareGiverAction() {
		logger.debug("CareGiverController - editFromViewCareGiverAction");
		CareGiver cg = this.careGiver;
		return editCareGiver(cg);
	}

	public String editCareGiver(CareGiver cg) {
		logger.debug("CareGiverController - editCareGiver");
		careGiver = cg;
		this.viewMode = VM_EDIT_CARE_GIVER;
		return "";
	}

	public String deleteCareGiver(CareGiver cg) {
		// HealthCareProviderDTO dto = converter.convertToDto(cg);
		logger.debug("CareGiverController - deleteCareGiver - coverted dto to cg");

		try {

			this.userMgmtService.deleteHealthCareProvider(cg.getCareGiverId());

			logger.debug("CareGiverController - delete - success");
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN,
					"You have successfully removed care giver information.", "DELETE"));
			modelList.remove(cg);

			loadModel(true);
			loadList();

		} catch (MHVException e) {
			logger.debug("CareGiverController - delete - fail");
		} catch (Exception e) {
			logger.debug("CareGiverController - delete - exception " + e.getMessage());
			logger.error(e);
			e.printStackTrace();
			throw new MHVRuntimeException(e);
		}
		return "";
	}

	public String deleteCareGiverAction() {
		logger.debug("CareGiverController - deleteCareGiverAction");
		CareGiver cg = (CareGiver) careGiverDataTable.getRowData();
		return deleteCareGiver(cg);
	}

	public String deleteFromViewAction() {
		return deleteCareGiver(this.careGiver);
	}

	public String viewMoreAction() {
		this.viewMode = VM_LONG_LIST;
		return "";
	}

	public String addCareGiverAction() {
		logger.debug("CareGiverController - addCareGiverAction");
		careGiver = new CareGiver();
		careGiver.setUserProfileId(userProfile.getId());
		this.viewMode = VM_EDIT_CARE_GIVER;
		return "";
	}

	public String returnToListAction() {
		this.careGiver = null;
		this.viewMode = VM_LONG_LIST;
		return "";
	}

	private void loadModel(boolean force) {
		if (force) {
			loadModel();
		} else if (modelList == null || modelList.size() == 0) {
			loadModel();
		}
	}

	@Override
	public void loadModel() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		// TODO REMOVE
		// -----------------------------------------------
		if (this.modelList == null) {
			this.modelList = new ArrayList<CareGiver>();
		}
		boolean test = true;
		CareGiver cg = new CareGiver();
		cg.setCareGiverId(1L);
		cg.setComments("comments");
		cg.setEmailAddress("a@a.com");
		cg.setFirstName("FN s");
		cg.setLastName("LN");
		cg.setOtherClinician("other clinician");
		cg.setProviderType("Specialist");
		cg.setWorkPhone("123-123-1234");
		cg.setWorkPhoneExt("1234");

		CareGiver cg2 = new CareGiver();
		cg2.setCareGiverId(1L);
		cg2.setComments("comments");
		cg2.setEmailAddress("a@a.com");
		cg2.setFirstName("FN p");
		cg2.setLastName("LN p ");
		cg2.setOtherClinician("other clinician");
		cg2.setProviderType("Primary");
		cg2.setWorkPhone("123-123-1234");

		CareGiver cg3 = new CareGiver();
		cg3.setCareGiverId(1L);
		cg3.setComments("comments");
		cg3.setEmailAddress("a@a.com");
		cg3.setFirstName("FN d");
		cg3.setLastName("LN d");
		cg3.setOtherClinician("Dentist");
		cg3.setProviderType("Dentist");
		cg3.setWorkPhone("123-123-1234");
		cg3.setWorkPhoneExt("1234");

		CareGiver cg4 = new CareGiver();
		cg4.setCareGiverId(1L);
		cg4.setComments("comments");
		cg4.setEmailAddress("a@a.com");
		cg4.setFirstName("FN o");
		cg4.setLastName("LN o");
		cg4.setOtherClinician("other clinician");
		cg4.setProviderType("Other Clinician");
		cg4.setWorkPhone("123-123-1234");
		cg4.setWorkPhoneExt("1234");

		CareGiver cg5 = new CareGiver();
		cg5.setCareGiverId(1L);
		cg5.setComments("comments");
		cg5.setEmailAddress("a@a.com");
		cg5.setFirstName("FN s");
		cg5.setLastName("LN");
		cg5.setOtherClinician("other clinician");
		cg5.setProviderType("Specialist");
		cg5.setWorkPhone("123-123-1234");
		cg5.setWorkPhoneExt("1234");

		CareGiver cg6 = new CareGiver();
		cg6.setCareGiverId(1L);
		cg6.setComments("comments");
		cg6.setEmailAddress("a@a.com");
		cg6.setFirstName("FN s");
		cg6.setLastName("LN");
		cg6.setOtherClinician("other clinician");
		cg6.setProviderType("Specialist");
		cg6.setWorkPhone("123-123-1234");
		cg6.setWorkPhoneExt("1234");

		this.modelList.add(cg);
		this.modelList.add(cg2);
		this.modelList.add(cg3);
		this.modelList.add(cg4);
		this.modelList.add(cg5);
		this.modelList.add(cg6);
		// -----------------------------------------------

		logger.debug("CareGiverController - loadModel");

		if (test == true)
			return;

		try {
			
			if (userProfile == null) {
				String userid = (String) session.getAttribute("LIFERAY_SHARED_userid", PortletSession.APPLICATION_SCOPE);
				if(userid == null || "".equals(userid)) {
					FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"Care Givers cannot be loaded if user has not authenticated.", "Load Care Givers"));
				}
				userProfile = getUserProfile(userid);
			}

			modelList = convert(this.userMgmtService.getHealthCareProviders(userProfile.getId()));

		} catch (Exception e) {
			logger.debug("CareGiverController - exception " + e.getMessage());
			logger.error(e);
			e.printStackTrace();
			throw new MHVRuntimeException(e);
		}
	}

	@PostConstruct
	@Override
	public void loadList() {
		logger.debug("AbstractListPortlet.loadList");
		if (modelList == null || modelList.size() == 0) {
			loadModel();
		}
		totalRows = modelList.size();
		logger.debug("AbstractListPortlet.loadList - totalRows: " + totalRows);
		logger.debug("AbstractListPortlet.loadList - firstRows: " + firstRow);
		viewList = new ArrayList<CareGiver>();
		// total = firstRow + rowsPerPage;

		// if( total > modelList.size() )
		// total = modelList.size();

		// pages = new Integer[0];

		viewList = modelList;// .subList(firstRow, total);

		// currentPage = (totalRows / rowsPerPage) - ((totalRows - firstRow) /
		// rowsPerPage) + 1;
		// totalPages = (totalRows / rowsPerPage) + ((totalRows % rowsPerPage !=
		// 0) ? 1 : 0);
		// int pagesLength = Math.min(pageRange, totalPages);
		// pages = new Integer[pagesLength];
		//
		// // firstPage must be greater than 0 and lesser than
		// totalPages-pageLength.
		// int firstPage = Math.min(Math.max(0, currentPage - (pageRange / 2)),
		// totalPages - pagesLength);
		//
		// // Create pages (page numbers for page links).
		// for (int i = 0; i < pagesLength; i++) {
		// pages[i] = ++firstPage;
		// }

	}

	/**
	 * Support method to convert a list of EmergencyContactDTO objects into a
	 * list of EmergencyContact
	 * 
	 * @param list
	 * @return
	 */
	private List<CareGiver> convert(List<HealthCareProviderDTO> list) {
		logger.debug("CareGiverController - convert - " + list.size());
		List<CareGiver> cgList = new ArrayList<CareGiver>();
		if (list != null && list.size() > 0) {
			for (HealthCareProviderDTO d : list) {
				logger.debug("CareGiverController - " + d.getFirstName());

				CareGiver cg = converter.convert(d);
				cgList.add(cg);
			}
		}
		return cgList;
	}

	private List<HealthCareProviderDTO> convertToDTO(List<CareGiver> list) {
		logger.debug("CareGiverController - convert - " + list.size());
		List<HealthCareProviderDTO> dtoList = new ArrayList<HealthCareProviderDTO>();
		if (list != null && list.size() > 0) {
			for (CareGiver cg : list) {
				logger.debug("CareGiverController - " + cg.getFirstName());

				HealthCareProviderDTO dto = converter.convertToDto(cg);
				dtoList.add(dto);
			}
		}
		return dtoList;
	}

	public String saveCareGiverAndAddAnotherAction() {
		saveCareGiverAction();
		if (this.viewMode.equals(VM_LONG_LIST)) {
			this.careGiver = new CareGiver();
			this.viewMode = VM_EDIT_CARE_GIVER;
		}

		return "";
	}

	public String resetAction() {
		this.careGiver = new CareGiver();
		this.viewMode = VM_EDIT_CARE_GIVER;

		return "";
	}

	public String cancelAction() {
		this.careGiver = new CareGiver();
		this.viewMode = VM_LONG_LIST;

		return "";
	}

	public String saveCareGiverAction() {
		try {
			
			this.userMgmtService.saveHealthCareProvider(converter.convertToDto(careGiver));
			
			logger.debug("CareGiverController -  - success");
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO,
					"You have successfully saved emergency contact information.", "SUCCESS"));
			this.viewMode = VM_LONG_LIST;
			
		} catch(MHVException e) {
			logger.debug("CareGiverController - saveCareGiverAction - fail");
			Map<String, String> map = e.getValidationErrorMessages();
			if (map != null) {
				for (Map.Entry<String, String> entry : map.entrySet()) {
					if (null != entry) {
						logger.debug("entry.getKey() : " + entry.getKey());
						logger.debug("entry.getValue() : " + entry.getValue());
					}
					FacesContext.getCurrentInstance().addMessage(null,
							new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
				}
			} else {
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR, "GENERIC_ERROR", "General error."));
			}
		} catch (Exception e) {
			logger.debug("CareGiverController -  - exception " + e.getMessage());
			logger.error(e);
			e.printStackTrace();
			throw new MHVRuntimeException(e);
		}
		loadModel(true);
		loadList();
		return "";
	}

	public List<CareGiver> getViewList() {
		return viewList;
	}

}
