package gov.va.med.mhv.usermgmt.web.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.faces.application.FacesMessage;
import javax.faces.component.UICommand;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.env.Environment;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;

@PropertySources(value={@PropertySource("classpath:/${MHV_ENV_PROPERTY}.usermgmt.liferay.properties"),
		   @PropertySource("classpath:/${MHV_ENV_PROPERTY}.usermgmt.properties")})
/**
 * Abstract class used to support list pages that require pagination.
 * @author DNS   SILVER
 *
 * @param <M>
 */
public abstract class AbstractListController<M> implements Serializable {

	private static final long serialVersionUID = 8170893154074047967L;

	private static Logger log = LogManager.getLogger(AbstractListController.class);
	
	protected UserProfileDTO userProfile = null;

	@Resource(name = "userMgmtServiceProxy")
	protected UserMgmtService userMgmtService;
	
	@Autowired
	protected Environment env;
	
	@Value("${endpointUrl}")
	private String endpointUrl;
	
	protected WebClient getWebClient(){
		log.debug("userService endpoint " + env.getProperty("endpointUrl"));
		log.debug("======endpointUrl======== " + endpointUrl);
		return WebClient.create(env.getProperty("endpointUrl"));
	}
	
	protected String getHomeURL(){
		return env.getProperty("logoutUrl");
	}
	//--------------------------------------------------------
	
	protected List<M> viewList = null;
	protected List<M> modelList = null;
	
	protected Integer toDisplay = new Integer(10);
	
	protected int totalRows;

    // Paging.
	protected int firstRow = 0;

	protected int rowsPerPage = 10;
	protected int totalPages = 1000;
	protected int pageRange = 10;
	protected Integer[] pages;
	protected int currentPage = 0;
	protected int total = 0;
	
/**
 * This method needs to be overriden by the child class  This method is intended to populate the modelList from the appropriates data source.
 */
	public abstract void loadModel();
	
	public void loadList() {
		log.debug("AbstractListPortlet.loadList");
		if( modelList == null || modelList.size() == 0 ) {
			loadModel();
		}
		totalRows = modelList.size();
		log.debug("AbstractListPortlet.loadList - totalRows: " + totalRows);
		log.debug("AbstractListPortlet.loadList - firstRows: " + firstRow);
		viewList = new ArrayList<M>();
		total = firstRow + rowsPerPage;

		if( total > modelList.size() )
			total = modelList.size();

		pages = new Integer[0];
		
		viewList = modelList.subList(firstRow, total);
        
		currentPage = (totalRows / rowsPerPage) - ((totalRows - firstRow) / rowsPerPage) + 1;
        totalPages = (totalRows / rowsPerPage) + ((totalRows % rowsPerPage != 0) ? 1 : 0);
        int pagesLength = Math.min(pageRange, totalPages);
        pages = new Integer[pagesLength];

        // firstPage must be greater than 0 and lesser than totalPages-pageLength.
        int firstPage = Math.min(Math.max(0, currentPage - (pageRange / 2)), totalPages - pagesLength);

        // Create pages (page numbers for page links).
        for (int i = 0; i < pagesLength; i++) {
            pages[i] = ++firstPage;
        }
		
    }
	
	/**
	 * Method to get the UserProfile object
	 * @param userName
	 * @return
	 */
	protected UserProfileDTO getUserProfile(String userName) {
		if( userProfile == null ) {
			
			try {
				userProfile = this.userMgmtService.getUserProfile(userName);
			} catch (MHVException e) {
				log.error("Error in getuserprofle:",e);
				FacesContext.getCurrentInstance().addMessage(
						null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error getting UserProfile", "Error getting UserProfile"));
			}
			
		}
	   return userProfile;
	}
	
	


	public List<M> getViewList() {
		return viewList;
	}

	public void setViewList(List<M> viewList) {
		this.viewList = viewList;
	}
	
//--------------- Pagination ------------------------------------
	public void pageFirst(ActionEvent e) {
		log.debug("AbstractListPortlet.pageFirst");
		page(0);
	}

    public void pageNext(ActionEvent e) {
		log.debug("AbstractListPortlet.pageNext");
        page(firstRow + rowsPerPage);
    }

    public void pagePrevious(ActionEvent e) {
		log.debug("AbstractListPortlet.pagePrevious");
        page(firstRow - rowsPerPage);
    }

    public void pageLast(ActionEvent e) {
		log.debug("AbstractListPortlet.pageLast");
        page(totalRows - ((totalRows % rowsPerPage != 0) ? totalRows % rowsPerPage : rowsPerPage));
    }

    public void page(ActionEvent event) {
		log.debug("AbstractListPortlet.page");
        page(((Integer) ((UICommand) event.getComponent()).getValue() - 1) * rowsPerPage);
    }
    public void display10(ActionEvent event) {
		log.debug("AbstractListPortlet.display10");
		rowsPerPage = 10;
		loadList();
    }
    public void display25(ActionEvent event) {
		log.debug("AbstractListPortlet.display25");
		rowsPerPage = 25;
		loadList();
    }
    public void display50(ActionEvent event) {
		log.debug("AbstractListPortlet.display50");
		rowsPerPage = 50;
		loadList();
    }
    public void display100(ActionEvent event) {
		log.debug("AbstractListPortlet.display100");
		rowsPerPage = 100;
		loadList();
    }

    private void page(int firstRow) {
		log.debug("AbstractListPortlet.page: " + firstRow);
        this.firstRow = firstRow;
        loadList(); // Load requested page.
    }
//----------------------------------------
	

	public Integer getToDisplay() {
		return toDisplay;
	}

	public void setToDisplay(Integer toDisplay) {
		this.toDisplay = toDisplay;
	}


	public int getTotalPages() {
		return totalPages;
	}

	public void setTotalPages(int totalPages) {
		this.totalPages = totalPages;
	}

	public int getPageRange() {
		return pageRange;
	}

	public void setPageRange(int pageRange) {
		this.pageRange = pageRange;
	}

	public Integer[] getPages() {
		return pages;
	}

	public void setPages(Integer[] pages) {
		this.pages = pages;
	}

	public int getCurrentPage() {
		return currentPage;
	}

	public void setCurrentPage(int currentPage) {
		this.currentPage = currentPage;
	}
	
    public int getFirstRow() {
    	return firstRow;
    }
    public void setFirstRow(int firstRow) {
    	this.firstRow = firstRow;
    }
    public int getTotalRows() {
		return totalRows;
	}

	public void setTotalRows(int totalRows) {
		this.totalRows = totalRows;
	}

	public int getRowsPerPage() {
		return rowsPerPage;
	}

	public void setRowsPerPage(int rowsPerPage) {
		this.rowsPerPage = rowsPerPage;
	}

	public int getTotal() {
		return total;
	}

	public void setTotal(int total) {
		this.total = total;
	}
}
