package gov.va.med.mhv.usermgmt.web.controller;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

import javax.annotation.Resource;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.service.AccountValidatorService;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;
import gov.va.med.mhv.usermgmt.web.converter.UserProfileDTOConverter;
import gov.va.med.mhv.usermgmt.web.converter.UserProfileFormConverter;
import gov.va.med.mhv.usermgmt.web.exception.MHVRuntimeException;

@PropertySources(value = {
	@PropertySource("classpath:/${MHV_ENV_PROPERTY}.usermgmt.liferay.properties"), 
	@PropertySource("classpath:/${MHV_ENV_PROPERTY}.usermgmt.properties")
})
public class AbstractController implements Serializable {

	private static final long serialVersionUID = -8611610134485398648L;

	private static Logger log = LogManager.getLogger(AbstractController.class);
	
	@Resource(name = "userMgmtServiceProxy")
	protected UserMgmtService userMgmtService;
	
	@Resource(name = "accountValidatorServiceProxy")
	protected AccountValidatorService accountValidatorService;
	
	@Resource(name = "userProfileDtoToFormBeanConverter")
	protected UserProfileDTOConverter userProfileDtoToFormBeanConverter;
	
	@Resource(name = "userProfileFormBeanToDtoConverter")
	protected UserProfileFormConverter userProfileFormBeanToDtoConverter;

	@Value("${endpointUrl}")
	private String endpointUrl;

	@Value("${logoutUrl}")
	private String logoutUrl;

	@Value("${termsCondArticleId}")
	private long termsCondArticleId;
	
	@Value("${appContextroot}")
	private String appContextRoot;
	
	protected String firstName="";
	protected String lastName="";
	protected Boolean saveMessage = false;
	protected Boolean saveAddNewMessage= false;
	protected Boolean addNewMessage = false;
	protected Boolean deleteMessage = false;
	
	protected ValueExpression sortColumn;
	protected String sortBy;
	protected Long userprofileId;
	protected int rowsPerPage;
	
    private final static String KEY="X-Authorization-Key";
    private final static String VAL="E8ECD-5F9D713DA-BC6CCF12D-ACAA-48";

	protected static final String LAST_UPDATED_DATE_FORMAT = "MM/dd/yyyy 'at' HHmm";
	protected static final String ERR_PRCS_RQST = "Error Processing request";
	
	private static Set<Character> SPECIAL_CHARS = createSpecialChars();
	
	private static final Set<Character> createSpecialChars() {
		Set<Character> specialChars = new HashSet<Character>( 32);
		specialChars.add( new Character( '!' ) );
		specialChars.add( new Character( '@' ) );
		specialChars.add( new Character( '#' ) );
		specialChars.add( new Character( '$' ) );
		specialChars.add( new Character( '%' ) );
		specialChars.add( new Character( '&' ) );
		specialChars.add( new Character( '*' ) );
		specialChars.add( new Character( '|' ) );
		specialChars.add( new Character( '?' ) );
		specialChars.add( new Character( '.' ) );
		specialChars.add( new Character( '_' ) );
		specialChars.add( new Character( '/' ) );
		specialChars.add( new Character( '<' ) );
		specialChars.add( new Character( '>' ) );
		specialChars.add( new Character( ';' ) );
		specialChars.add( new Character( ':' ) );
		specialChars.add( new Character( '"' ) );
		specialChars.add( new Character( '\\' ) );
		specialChars.add( new Character( '=' ) );
		specialChars.add( new Character( '+' ) );
		specialChars.add( new Character( '-' ) );
		specialChars.add( new Character( '`' ) );
		specialChars.add( new Character( '~' ) );
		specialChars.add( new Character( ')' ) );
		specialChars.add( new Character( '(' ) );
		specialChars.add( new Character( ',' ) );
		specialChars.add( new Character( '\'' ) );
		specialChars.add( new Character( '{' ) );
		specialChars.add( new Character( '}' ) );
		//CR1256 to add ^ [ and ] as special characters
		specialChars.add( new Character( '^' ) );
		specialChars.add( new Character( '[' ) );
		specialChars.add( new Character( ']' ) );
		return specialChars;
	}	
	
	
	

	protected WebClient getWebClient() {
		if (log.isDebugEnabled()) {
			log.debug("userService endpoint " + endpointUrl);
		}
		return WebClient.create(endpointUrl);
	}

	protected String getHomeURL() {
		return logoutUrl;
	}
	
	/**
	 * Method to get the UserProfile object
	 * 
	 * @param userName
	 * @return
	 */
	protected UserProfileDTO getUserProfile(String userName) {
		
		UserProfileDTO userProfile = null;
		
		try {
			userProfile = this.userMgmtService.getUserProfile(userName);
		} catch (MHVException e) {
			log.error("Error in getuserprofle:",e);
			FacesContext.getCurrentInstance().addMessage(
					null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error getting UserProfile", e.getFailureMessage()));
		}
		return userProfile;
	}
	
	protected UserProfileDTO getUserProfile(Long userid) {
		
		UserProfileDTO userProfile = null;
		
		try {
			userProfile = this.userMgmtService.getUserProfileById(Long.valueOf(userid));
		} catch (MHVException e) {
			log.error("Error in getuserprofle:",e);
			
			FacesContext.getCurrentInstance().addMessage(
					null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Error getting UserProfile", "Error getting UserProfile"));
		}
		
		return userProfile;
	}

	@SuppressWarnings("unchecked")
	protected Timestamp getTermsModifiedTime() {
		Timestamp termsModifiedTime = null;
		JournalArticle journalArticle = null;

		try {
			// journalArticle = JournalArticleLocalServiceUtil.getLatestArticle(groupId, termsCondArticleId);

			DynamicQuery dq = DynamicQueryFactoryUtil.forClass(JournalArticle.class, PortalClassLoaderUtil.getClassLoader());
			dq.add(PropertyFactoryUtil.forName("articleId").eq(String.valueOf(this.termsCondArticleId)));
			List<JournalArticle> articles = (List<JournalArticle>) JournalArticleLocalServiceUtil.dynamicQuery(dq);

			// use any one of the returned articles to get the resource id.
			long rsrcId = articles.get(0).getResourcePrimKey();

			// using that resource id you can get the latest version
			journalArticle = JournalArticleLocalServiceUtil.getLatestArticle(rsrcId);

			// get modified date of article
			//termsModifiedTime = new Timestamp(journalArticle.getModifiedDate().getTime());
			
			//TimeStamp need to be updated for new Terms and Conditions. 
			//Need to replace this with ArticleID in each env property file. Auto insert has been disabled.
			String finalTCDate = "05/17/2013 10:45:56 AM";
			SimpleDateFormat sdfny = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss a");
			sdfny.setTimeZone(TimeZone.getTimeZone("America/New_York"));
			termsModifiedTime = new Timestamp(sdfny.parse(finalTCDate).getTime());
		      

		} catch (Exception e) {
			log.error("Error getting getTermsModifiedTime ", e);
		}

		if (log.isDebugEnabled()) {
			log.debug("termsModifiedTime: " + termsModifiedTime);
		}

		return termsModifiedTime;
	}

	public String getAppContextRoot() {
		return appContextRoot;
	}
	
	public String getMhvContext(){
		String context = PropsUtil.get("mhv.context");
		return  context;
    }
	
	/**
	 * get userScreenName from session
	 * 
	 * @return
	 */
	protected String getUserScreenName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		String userScreenName = (String) session.getAttribute("LIFERAY_SHARED_userid", PortletSession.APPLICATION_SCOPE);

		return userScreenName;
	}
	
	
	protected String getUserAccountType(){
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		String accountType =(String)session.getAttribute("LIFERAY_SHARED_accountType",PortletSession.APPLICATION_SCOPE);
		return accountType;
	}
	
	
	protected Long getUserProfileId() {
		Long userprofileId = null;
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		Object profileId = session.getAttribute("LIFERAY_SHARED_userprofileid", PortletSession.APPLICATION_SCOPE);
		if (profileId != null) {
			userprofileId = (Long) profileId;
		}
		return userprofileId;
	}
	
	
	/**
	 * get userProfile for userId
	 * 
	 * @param userId
	 * @return
	 */
	protected UserProfileDTO getCurrentUserProfile(String userName) {
		UserProfileDTO userProfileDto = null;

		if (log.isDebugEnabled()) {
			log.debug("usermgmtEndpointUrl " + endpointUrl);
		}
		try {
			
			if (null != userName && userName.length() > 0) {
				userProfileDto = this.userMgmtService.getUserProfile(userName);
			} else {
				log.error("userName is null");
				throw new MHVRuntimeException("userName is null");
			}
		} catch (Exception e) {
			log.error("Error in fetching user data " + e);
			throw new MHVRuntimeException(e);
		} 

		return userProfileDto;
	}
	
	protected void processErrorMessages(gov.va.med.mhv.common.api.util.ResponseUtil response) {
		log.info("isFailure : " + response.isFailure());
		// response has errors
		if (null != response && response.isFailure()) {
			Map<String, String> validationErrors = response.getValidationErrors();

			if (log.isDebugEnabled()) {
				int size = null != validationErrors ? validationErrors.size() : 0;
				log.debug("validationErrors.size() : " + size);
			}

			// check if there are any validation errors in response object
			if (null != validationErrors && validationErrors.size() > 0) {

				for (Map.Entry<String, String> err : validationErrors.entrySet()) {
					if (log.isDebugEnabled()) {
						if (null != err) {
							log.debug("entry.getKey() : " + err.getKey());
							log.debug("entry.getValue() : " + err.getValue());
						}
					}
					FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, err.getValue(), err.getValue()));
				}
			}

			// check for non-validation errors in response object
			if (null != response.getFailureMessage() && response.getFailureMessage().length() > 0) {
				if (log.isDebugEnabled()) {
					log.debug("FailureMessage : " + response.getFailureMessage());
				}

				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}
		}
	}
	
	protected void processErrorMessages(MHVException exp) {
		// response has errors
		if (null != exp.getErrorCode()) {
			Map<String, String> validationErrors = exp.getValidationErrorMessages();

			if (log.isDebugEnabled()) {
				int size = null != validationErrors ? validationErrors.size() : 0;
				log.debug("validationErrors.size() : " + size);
			}

			// check if there are any validation errors in response object
			if (null != validationErrors && validationErrors.size() > 0) {

				for (Map.Entry<String, String> err : validationErrors.entrySet()) {
					if (log.isDebugEnabled()) {
						if (null != err) {
							log.debug("entry.getKey() : " + err.getKey());
							log.debug("entry.getValue() : " + err.getValue());
						}
					}
					FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, err.getValue(), err.getValue()));
				}
			}

			// check for non-validation errors in response object
			if (null != exp.getFailureMessage() && exp.getFailureMessage().length() > 0) {
				if (log.isDebugEnabled()) {
					log.debug("FailureMessage : " + exp.getFailureMessage());
				}

				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
			}
		}
	}
	
	
	protected void resetMessages(){
		saveMessage = false;
		saveAddNewMessage = false;
		addNewMessage = false;
		deleteMessage = false;
	}
	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public Boolean getSaveMessage() {
		return saveMessage;
	}

	public void setSaveMessage(Boolean saveMessage) {
		this.saveMessage = saveMessage;
	}

	public Boolean getSaveAddNewMessage() {
		return saveAddNewMessage;
	}

	public void setSaveAddNewMessage(Boolean saveAddNewMessage) {
		this.saveAddNewMessage = saveAddNewMessage;
	}

	public Boolean getAddNewMessage() {
		return addNewMessage;
	}

	public void setAddNewMessage(Boolean addNewMessage) {
		this.addNewMessage = addNewMessage;
	}

	public Boolean getDeleteMessage() {
		return deleteMessage;
	}

	public void setDeleteMessage(Boolean deleteMessage) {
		this.deleteMessage = deleteMessage;
	}

	public ValueExpression getSortColumn() {
		return sortColumn;
	}

	public void setSortColumn(ValueExpression sortColumn) {
		this.sortColumn = sortColumn;
	}

	public String getSortBy() {
		return sortBy;
	}

	public void setSortBy(String sortBy) {
		this.sortBy = sortBy;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

	public int getRowsPerPage() {
		return rowsPerPage;
	}

	public void setRowsPerPage(int rowsPerPage) {
		this.rowsPerPage = rowsPerPage;
	}
	

	public void validatePassword(UserProfileDTO userProfileDto,boolean changePassword) {
		String userName = userProfileDto.getUserName();
		String password = userProfileDto.getPassword();
		String confirmPassword = userProfileDto.getConfPassword();
		String oldPassword=userProfileDto.getOldPassword();

		boolean blankValues = false;
		
		if(changePassword){
			if( StringUtils.isBlank( oldPassword ) ) {
				FacesContext.getCurrentInstance().addMessage(
						null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,
								"Current Password is required ", "NULL_ANSWER"));	
	
				blankValues = true;
			}
		}

		
		if( StringUtils.isBlank( password ) ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"Password is required ", "NULL_ANSWER"));	

			blankValues = true;
		}
		if( StringUtils.isBlank( confirmPassword ) ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"Confirm Password is required ", "NULL_ANSWER"));
			blankValues = true;
		}
		if( !password.equals( confirmPassword ) ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"The specified passwords do not match.", "NULL_ANSWER"));	
			blankValues = true;

		}

		if( blankValues ) {
			return;
		}
		if( password.equals( userName ) ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"The password must be different from the user name.", "NULL_ANSWER"));	
		}

		if( password.length() < 8 || password.length() > 12 ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"The password must be between 6 and 12 characters.", "NULL_ANSWER"));			
		}

		if( StringUtils.contains( password, " " ) ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"The password may not contain spaces.", "NULL_ANSWER"));				}

		boolean hasSpecialChar = false;
		boolean hasDigit = false;
		boolean hasLetter = false;
		for( int i=0; i<password.length(); i++ ) {
			if( hasSpecialChar && hasDigit && hasLetter ) {
				break;
			}
			char c = password.charAt( i );
			if( !hasLetter && Character.isLetter( c ) ) {
				hasLetter = true;
			}
			else if( !hasDigit && Character.isDigit( c ) ) {
				hasDigit = true;
			}
			else if( !hasSpecialChar && SPECIAL_CHARS.contains( new Character( c ) ) ) {
				hasSpecialChar = true;
			}
		}
		if( ! hasSpecialChar ) {
			if( StringUtils.contains( password, " " ) ) {
				FacesContext.getCurrentInstance().addMessage(
						null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,
								"The password must contain at least one special character.", "NULL_ANSWER"));	
			}
			if( ! hasLetter ) {
				FacesContext.getCurrentInstance().addMessage(
						null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,
								"The password must contain at least one letter (A-Z or a-z).", "NULL_ANSWER"));	

			}		
		}
		if( ! hasDigit ) {
			FacesContext.getCurrentInstance().addMessage(
					null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,
							"The password must contain at least one number (0-9).", "NULL_ANSWER"));	
		}
	}

}
