package gov.va.med.mhv.usermgmt.util.mvi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlOptions;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mvi.xsd.ActClassControlAct;
import gov.va.med.mhv.mvi.xsd.CD;
import gov.va.med.mhv.mvi.xsd.COCTMT090100UV01AssignedPerson;
import gov.va.med.mhv.mvi.xsd.COCTMT090100UV01Person;
import gov.va.med.mhv.mvi.xsd.CS;
import gov.va.med.mhv.mvi.xsd.CommunicationFunctionType;
import gov.va.med.mhv.mvi.xsd.EN;
import gov.va.med.mhv.mvi.xsd.EntityClassDevice;
import gov.va.med.mhv.mvi.xsd.II;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Device;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Receiver;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Sender;
import gov.va.med.mhv.mvi.xsd.PRPAIN201309UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201309UV02Document.PRPAIN201309UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201309UV02QUQIMT021001UV01ControlActProcess;
import gov.va.med.mhv.mvi.xsd.PRPAMT201307UV02ParameterList;
import gov.va.med.mhv.mvi.xsd.PRPAMT201307UV02PatientIdentifier;
import gov.va.med.mhv.mvi.xsd.PRPAMT201307UV02QueryByParameter;
import gov.va.med.mhv.mvi.xsd.QUQIMT021001UV01DataEnterer;
import gov.va.med.mhv.mvi.xsd.TEL;
import gov.va.med.mhv.mvi.xsd.TS;
import gov.va.med.mhv.mvi.xsd.XActMoodIntentEvent;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;

@Component
public class CreateMVISearchByEdipiRequest {

	private final Logger log = LogManager.getLogger(CreateMVISearchByEdipiRequest.class);

	/**
	 * @param args
	 */
	@SuppressWarnings("rawtypes")
	public Object createMVISearchByEdipiRequest(String dodValue, MviProperties properties, String versionInfo) {
		if (properties.getIsMviMockSearchByEdipiEnabled())
			return createMockMVISearchByEdipiRequest();

		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		String dataEntererId = "";
		String given = "";
		String family = "";
		
		if(versionInfo != null) {
			String[] versionProps = versionInfo.split(",");
			for (String prop : versionProps) {
				if(prop.startsWith("dataEntererId")) {
					dataEntererId = prop.split("=")[1];
				} else if(prop.startsWith("given")) {
					given = prop.split("=")[1];
				} else if(prop.startsWith("family")) {
					family = prop.split("=")[1];
				}
			}
		}
		
		PRPAIN201309UV02Document root1309Doc = PRPAIN201309UV02Document.Factory.newInstance();

		PRPAIN201309UV02 root1309Req = root1309Doc.addNewPRPAIN201309UV02();

		root1309Req.setITSVersion(MviConstants.MVI_XML_REQ_ITS_VERSION);

		II rootId = root1309Req.addNewId();
		rootId.setRoot(properties.getMviRootId());
		String mcidExtension = MviUtil.getMCIDExtension();
		long mcidUniqValue = MviUtil.getUniqueId();
		rootId.setExtension(mcidExtension + String.valueOf(mcidUniqValue));

		TS creationTime = root1309Req.addNewCreationTime();
		creationTime.setValue(MviUtil.getCreationTime());
		/*
		 <urn:creationTime value="20070428150301"/>
		 <urn:interactionId root="2.16.840.1.113883.1.6" extension="PRPA_IN201309UV02"/>
		 */
		II interactionId = root1309Req.addNewInteractionId();
		interactionId.setRoot(properties.getMviInteractionId());
		interactionId.setExtension(MviConstants.MVI_INTERACTION_CORRES_TYPE);
		/*
		 <urn:processingCode code="T"/>
		 */
		CS processingCode = root1309Req.addNewProcessingCode();
		if (properties.getMviEnvType().equalsIgnoreCase("prod"))
			processingCode.setCode(MviConstants.MVI_PROCESSING_PROD_CODE);
		else
			processingCode.setCode(MviConstants.MVI_PROCESSING_NONPROD_CODE);
		/*
		 <urn:processingModeCode code="T"/>
		 */
		CS processingModeCode = root1309Req.addNewProcessingModeCode();
		processingModeCode.setCode(MviConstants.MVI_PROCESSING_MODE_CODE);
		/*
		 <urn:acceptAckCode code="AL"/>
		 */
		CS acceptAckCode = root1309Req.addNewAcceptAckCode();
		acceptAckCode.setCode(MviConstants.MVI_ACCEPT_ACK_CODE);
		/*
		<urn:receiver typeCode="RCV">
		    <urn:device classCode="DEV" determinerCode="INSTANCE">
		        <urn:id root="2.16.840.1.113883.4.349"/>
		        <urn:telecom value="http://servicelocation/PDQuery"/>
		    </urn:device>
		</urn:receiver>
		 */
		MCCIMT000100UV01Receiver receiver = root1309Req.addNewReceiver();
		receiver.setTypeCode(CommunicationFunctionType.RCV);
		MCCIMT000100UV01Device device = receiver.addNewDevice();
		device.setClassCode(EntityClassDevice.DEV);
		device.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II deviceId = device.addNewId();
		// deviceId.setRoot(properties.getVaOidValue());
		deviceId.setRoot(properties.getMviRootId());

		// TEL deviceTelecom = device.addNewTelecom();
		// deviceTelecom.setValue("http://servicelocation/PDQuery");
		/*
		<urn:sender typeCode="SND">
			<urn:device classCode="DEV" determinerCode="INSTANCE">
		    	<urn:id extension="200MH" root="2.16.840.1.113883.3.933"/>
			</urn:device>
		</urn:sender>
		 */
		MCCIMT000100UV01Sender sender = root1309Req.addNewSender();
		sender.setTypeCode(CommunicationFunctionType.SND);
		MCCIMT000100UV01Device senderDevice = sender.addNewDevice();
		senderDevice.setClassCode(EntityClassDevice.DEV);
		senderDevice.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II senderId = senderDevice.addNewId();
		senderId.setExtension(properties.getMviReceivingFacilityId());
		senderId.setRoot(properties.getMviRootId());
		// if(properties.getMviEnvType().equalsIgnoreCase("prod"))
		// senderId.setRoot(properties.getMviProdDodrootId());
		// else
		// senderId.setRoot(properties.getMviNonprodDodrootId());

		/*
		<urn:controlActProcess classCode="CACT" moodCode="EVN">
		<urn:code codeSystem="2.16.840.1.113883.1.6" code="PRPA_TE201305UV02"/>
		 */
		PRPAIN201309UV02QUQIMT021001UV01ControlActProcess controlActProcess = root1309Req.addNewControlActProcess();
		root1309Req.setControlActProcess(controlActProcess);
		controlActProcess.setClassCode(ActClassControlAct.CACT);
		controlActProcess.setMoodCode(XActMoodIntentEvent.EVN);
		
		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		if(versionInfo != null) {
			QUQIMT021001UV01DataEnterer dataEnterer = controlActProcess.addNewDataEnterer();
			dataEnterer.setContextControlCode("AP");
			dataEnterer.setTypeCode("ENT");
			COCTMT090100UV01AssignedPerson assignedPersons = dataEnterer.addNewAssignedPerson();
			assignedPersons.setClassCode("ASSIGNED");
			
			II assignedPersonDataEntererId = assignedPersons.addNewId();
			
			if(dataEntererId != null && dataEntererId.length() > 0) {
				assignedPersonDataEntererId.setExtension(dataEntererId);
			}

			assignedPersonDataEntererId.setRoot(properties.getMviRootId());
			
			COCTMT090100UV01Person assignedPerson = assignedPersons.addNewAssignedPerson();
			assignedPerson.setDeterminerCode("INSTANCE");
			assignedPerson.setClassCode("PSN");
			EN en = assignedPerson.addNewName();
			if(given != null && given.length() > 0) {
				en.addGiven(given);
			}
			
			if(family != null && family.length() > 0) {
				en.addFamily(family);
			}
		}
		
		
		CD controlCode = controlActProcess.addNewCode();
		controlCode.setCodeSystem(properties.getMviInteractionId());
		controlCode.setCode(MviConstants.MVI_CORRES_CONTROL_CODE);
		/*
		<urn:queryByParameter>
		    <urn:queryId root="2.16.840.1.113883.3.933" extension="18204"/>
		    <urn:statusCode code="new"/>
		    <urn:responsePriorityCode code="l"/>
		    <urn:parameterList>
		        <urn:patientIdentifier>
		            <urn:value root="2.16.840.1.113883.4.349" extension="1008540319V974321^NI"/>
		            <urn:semanticsText>Patient.Id</urn:semanticsText>
		        </urn:patientIdentifier>
		    </urn:parameterList>
		</urn:queryByParameter>
		 */
		PRPAMT201307UV02QueryByParameter controlQueryParameter = controlActProcess.addNewQueryByParameter();
		II controlQueryId = controlQueryParameter.addNewQueryId();
		controlQueryId.setRoot(properties.getMviRootId());
		// if(properties.getMviEnvType().equalsIgnoreCase("prod"))
		// controlQueryId.setRoot(properties.getMviProdDodrootId());
		// else
		// controlQueryId.setRoot(properties.getMviNonprodDodrootId());

		controlQueryId.setExtension(String.valueOf(mcidUniqValue));

		CS controlStatusCode = controlQueryParameter.addNewStatusCode();
		controlStatusCode.setCode(MviConstants.MVI_NEW_STATUS_CODE);
		CS controlResPriorityCode = controlQueryParameter.addNewResponsePriorityCode();
		controlResPriorityCode.setCode(MviConstants.MVI_RES_PRIORITY_CODE);
		PRPAMT201307UV02ParameterList controlQueryParameterList = controlQueryParameter.addNewParameterList();

		PRPAMT201307UV02PatientIdentifier patientIdentifier = controlQueryParameterList.addNewPatientIdentifier();
		II patientIdentifierValue = patientIdentifier.addNewValue();

		// String ICN="1012581128V549975";
		String identfierExtensionFinal =
			dodValue.concat(MviConstants.CARET_SYMBOL + properties.getMviNationalIdentifier() + MviConstants.CARET_SYMBOL +
				properties.getDodFacilityAssigning() + MviConstants.CARET_SYMBOL + properties.getDodAssigningAuthority());
		// patientIdentifierValue.setRoot(properties.getVaOidValue());
		if (properties.getMviEnvType().equalsIgnoreCase("prod"))
			patientIdentifierValue.setRoot(properties.getMviProdDodrootId());
		else
			patientIdentifierValue.setRoot(properties.getMviNonprodDodrootId());
		patientIdentifierValue.setExtension(identfierExtensionFinal);
		patientIdentifier.setSemanticsText(MviConstants.MVI_PATIENT_ID);

		// Printing the Request XML For fine output
		XmlOptions options = new XmlOptions();
		options.put(XmlOptions.LOAD_LINE_NUMBERS);
		options.setSavePrettyPrint();
		options.setSavePrettyPrintIndent(4);
		if (log.isDebugEnabled())
			log.debug("\n" + root1309Doc.xmlText(options));

		// TEST the validity of an XML
		List validationErrors = new ArrayList();
		options.setErrorListener(validationErrors);

		boolean valid = root1309Doc.validate(options);
		if (valid) {
			if (log.isDebugEnabled())
				log.debug("Its valid 1309 Search By Edipi Request xml");
		} else {
			Iterator itr = validationErrors.iterator();
			if (log.isDebugEnabled()) {
				while (itr.hasNext()) {
					log.error("Not a valid 1309 EDIPI xml : " + itr.next().toString());
				}
			}
		}
		return root1309Doc.xmlText();

	}

	@SuppressWarnings("rawtypes")
	private Object createMockMVISearchByEdipiRequest() {

		PRPAIN201309UV02Document root1309Doc = PRPAIN201309UV02Document.Factory.newInstance();

		PRPAIN201309UV02 root1309Req = root1309Doc.addNewPRPAIN201309UV02();

		root1309Req.setITSVersion("XML_1.0");

		II rootId = root1309Req.addNewId();
		rootId.setRoot("2.16.840.1.113883.3.933");
		rootId.setExtension("MCID-12345");

		TS creationTime = root1309Req.addNewCreationTime();
		creationTime.setValue("20070428150301");

		II interactionId = root1309Req.addNewInteractionId();
		interactionId.setRoot("2.16.840.1.113883.1.6");
		interactionId.setExtension("PRPA_IN201309UV02");

		CS processingCode = root1309Req.addNewProcessingCode();
		processingCode.setCode("T");
		CS processingModeCode = root1309Req.addNewProcessingModeCode();
		processingModeCode.setCode("T");

		CS acceptAckCode = root1309Req.addNewAcceptAckCode();
		acceptAckCode.setCode("AL");

		MCCIMT000100UV01Receiver receiver = root1309Req.addNewReceiver();
		receiver.setTypeCode(CommunicationFunctionType.RCV);
		MCCIMT000100UV01Device device = receiver.addNewDevice();
		device.setClassCode(EntityClassDevice.DEV);
		device.setDeterminerCode("INSTANCE");
		II deviceId = device.addNewId();
		deviceId.setRoot("2.16.840.1.113883.4.349");
		TEL deviceTelecom = device.addNewTelecom();
		deviceTelecom.setValue("http://servicelocation/PDQuery");

		MCCIMT000100UV01Sender sender = root1309Req.addNewSender();
		sender.setTypeCode(CommunicationFunctionType.SND);
		MCCIMT000100UV01Device senderDevice = sender.addNewDevice();
		senderDevice.setClassCode(EntityClassDevice.DEV);
		senderDevice.setDeterminerCode("INSTANCE");
		II senderId = senderDevice.addNewId();
		senderId.setExtension("200MH");
		senderId.setRoot("2.16.840.1.113883.3.933");

		PRPAIN201309UV02QUQIMT021001UV01ControlActProcess controlActProcess = root1309Req.addNewControlActProcess();
		root1309Req.setControlActProcess(controlActProcess);
		controlActProcess.setClassCode(ActClassControlAct.CACT);
		controlActProcess.setMoodCode(XActMoodIntentEvent.EVN);
		CD controlCode = controlActProcess.addNewCode();
		controlCode.setCodeSystem("2.16.840.1.113883.1.6");
		controlCode.setCode("PRPA_TE201305UV02");

		PRPAMT201307UV02QueryByParameter controlQueryParameter = controlActProcess.addNewQueryByParameter();
		II controlQueryId = controlQueryParameter.addNewQueryId();
		controlQueryId.setRoot("2.16.840.1.113883.3.933");
		controlQueryId.setExtension("18204");

		CS controlStatusCode = controlQueryParameter.addNewStatusCode();
		controlStatusCode.setCode("new");
		CS controlResPriorityCode = controlQueryParameter.addNewResponsePriorityCode();
		controlResPriorityCode.setCode("l");
		PRPAMT201307UV02ParameterList controlQueryParameterList = controlQueryParameter.addNewParameterList();

		PRPAMT201307UV02PatientIdentifier patientIdentifier = controlQueryParameterList.addNewPatientIdentifier();
		II patientIdentifierValue = patientIdentifier.addNewValue();

		String ICN = "1008540319V974321";
		String identifierExtension = "^NI";
		String identfierExtensionFinal = ICN.concat(identifierExtension);
		patientIdentifierValue.setRoot("2.16.840.1.113883.4.349");
		patientIdentifierValue.setExtension(identfierExtensionFinal);
		patientIdentifier.setSemanticsText("Patient.Id");

		// Printing the Request XML For fine output
		XmlOptions options = new XmlOptions();
		options.put(XmlOptions.LOAD_LINE_NUMBERS);
		options.setSavePrettyPrint();
		options.setSavePrettyPrintIndent(4);
		if (log.isDebugEnabled())
			log.debug("\n" + root1309Doc.xmlText(options));

		// TEST the validity of an XML
		List validationErrors = new ArrayList();
		options.setErrorListener(validationErrors);

		boolean valid = root1309Doc.validate(options);
		if (valid) {
			if (log.isDebugEnabled())
				log.debug("Its valid 1309 Get Corresponding Request xml");
		} else {
			Iterator itr = validationErrors.iterator();
			if (log.isDebugEnabled()) {
				while (itr.hasNext()) {
					log.error("Not a valid 1309 Corresponding Request xml : " + itr.next().toString());
				}
			}
		}
		return root1309Doc.xmlText();
	}
}
